// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains the DDoS protection settings of the public IP.
 */
@Fluent
public final class DdosSettings implements JsonSerializable<DdosSettings> {
    /*
     * The DDoS protection mode of the public IP
     */
    private DdosSettingsProtectionMode protectionMode;

    /*
     * The DDoS protection plan associated with the public IP. Can only be set if ProtectionMode is Enabled
     */
    private SubResource ddosProtectionPlan;

    /**
     * Creates an instance of DdosSettings class.
     */
    public DdosSettings() {
    }

    /**
     * Get the protectionMode property: The DDoS protection mode of the public IP.
     * 
     * @return the protectionMode value.
     */
    public DdosSettingsProtectionMode protectionMode() {
        return this.protectionMode;
    }

    /**
     * Set the protectionMode property: The DDoS protection mode of the public IP.
     * 
     * @param protectionMode the protectionMode value to set.
     * @return the DdosSettings object itself.
     */
    public DdosSettings withProtectionMode(DdosSettingsProtectionMode protectionMode) {
        this.protectionMode = protectionMode;
        return this;
    }

    /**
     * Get the ddosProtectionPlan property: The DDoS protection plan associated with the public IP. Can only be set if
     * ProtectionMode is Enabled.
     * 
     * @return the ddosProtectionPlan value.
     */
    public SubResource ddosProtectionPlan() {
        return this.ddosProtectionPlan;
    }

    /**
     * Set the ddosProtectionPlan property: The DDoS protection plan associated with the public IP. Can only be set if
     * ProtectionMode is Enabled.
     * 
     * @param ddosProtectionPlan the ddosProtectionPlan value to set.
     * @return the DdosSettings object itself.
     */
    public DdosSettings withDdosProtectionPlan(SubResource ddosProtectionPlan) {
        this.ddosProtectionPlan = ddosProtectionPlan;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protectionMode",
            this.protectionMode == null ? null : this.protectionMode.toString());
        jsonWriter.writeJsonField("ddosProtectionPlan", this.ddosProtectionPlan);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DdosSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DdosSettings if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DdosSettings.
     */
    public static DdosSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DdosSettings deserializedDdosSettings = new DdosSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("protectionMode".equals(fieldName)) {
                    deserializedDdosSettings.protectionMode = DdosSettingsProtectionMode.fromString(reader.getString());
                } else if ("ddosProtectionPlan".equals(fieldName)) {
                    deserializedDdosSettings.ddosProtectionPlan = SubResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDdosSettings;
        });
    }
}
