// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitConnectionInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for ListConnections API service call retrieves all global reach connections that belongs to a Private
 * Peering for an ExpressRouteCircuit.
 */
@Fluent
public final class ExpressRouteCircuitConnectionListResult
    implements JsonSerializable<ExpressRouteCircuitConnectionListResult> {
    /*
     * The global reach connection associated with Private Peering in an ExpressRoute Circuit.
     */
    private List<ExpressRouteCircuitConnectionInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ExpressRouteCircuitConnectionListResult class.
     */
    public ExpressRouteCircuitConnectionListResult() {
    }

    /**
     * Get the value property: The global reach connection associated with Private Peering in an ExpressRoute Circuit.
     * 
     * @return the value value.
     */
    public List<ExpressRouteCircuitConnectionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The global reach connection associated with Private Peering in an ExpressRoute Circuit.
     * 
     * @param value the value value to set.
     * @return the ExpressRouteCircuitConnectionListResult object itself.
     */
    public ExpressRouteCircuitConnectionListResult withValue(List<ExpressRouteCircuitConnectionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ExpressRouteCircuitConnectionListResult object itself.
     */
    public ExpressRouteCircuitConnectionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteCircuitConnectionListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteCircuitConnectionListResult if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteCircuitConnectionListResult.
     */
    public static ExpressRouteCircuitConnectionListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteCircuitConnectionListResult deserializedExpressRouteCircuitConnectionListResult
                = new ExpressRouteCircuitConnectionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ExpressRouteCircuitConnectionInner> value
                        = reader.readArray(reader1 -> ExpressRouteCircuitConnectionInner.fromJson(reader1));
                    deserializedExpressRouteCircuitConnectionListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedExpressRouteCircuitConnectionListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteCircuitConnectionListResult;
        });
    }
}
