// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The current status of the test.
 */
public final class FailoverTestStatus extends ExpandableStringEnum<FailoverTestStatus> {
    /**
     * Static value NotStarted for FailoverTestStatus.
     */
    public static final FailoverTestStatus NOT_STARTED = fromString("NotStarted");

    /**
     * Static value Starting for FailoverTestStatus.
     */
    public static final FailoverTestStatus STARTING = fromString("Starting");

    /**
     * Static value Running for FailoverTestStatus.
     */
    public static final FailoverTestStatus RUNNING = fromString("Running");

    /**
     * Static value StartFailed for FailoverTestStatus.
     */
    public static final FailoverTestStatus START_FAILED = fromString("StartFailed");

    /**
     * Static value Stopping for FailoverTestStatus.
     */
    public static final FailoverTestStatus STOPPING = fromString("Stopping");

    /**
     * Static value Completed for FailoverTestStatus.
     */
    public static final FailoverTestStatus COMPLETED = fromString("Completed");

    /**
     * Static value StopFailed for FailoverTestStatus.
     */
    public static final FailoverTestStatus STOP_FAILED = fromString("StopFailed");

    /**
     * Static value Invalid for FailoverTestStatus.
     */
    public static final FailoverTestStatus INVALID = fromString("Invalid");

    /**
     * Static value Expired for FailoverTestStatus.
     */
    public static final FailoverTestStatus EXPIRED = fromString("Expired");

    /**
     * Creates a new instance of FailoverTestStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public FailoverTestStatus() {
    }

    /**
     * Creates or finds a FailoverTestStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding FailoverTestStatus.
     */
    public static FailoverTestStatus fromString(String name) {
        return fromString(name, FailoverTestStatus.class);
    }

    /**
     * Gets known FailoverTestStatus values.
     * 
     * @return known FailoverTestStatus values.
     */
    public static Collection<FailoverTestStatus> values() {
        return values(FailoverTestStatus.class);
    }
}
