// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The operation for configuring intrusion detection.
 */
@Fluent
public final class FirewallPolicyIntrusionDetectionConfiguration
    implements JsonSerializable<FirewallPolicyIntrusionDetectionConfiguration> {
    /*
     * List of specific signatures states.
     */
    private List<FirewallPolicyIntrusionDetectionSignatureSpecification> signatureOverrides;

    /*
     * List of rules for traffic to bypass.
     */
    private List<FirewallPolicyIntrusionDetectionBypassTrafficSpecifications> bypassTrafficSettings;

    /*
     * IDPS Private IP address ranges are used to identify traffic direction (i.e. inbound, outbound, etc.). By default,
     * only ranges defined by IANA RFC 1918 are considered private IP addresses. To modify default ranges, specify your
     * Private IP address ranges with this property
     */
    private List<String> privateRanges;

    /**
     * Creates an instance of FirewallPolicyIntrusionDetectionConfiguration class.
     */
    public FirewallPolicyIntrusionDetectionConfiguration() {
    }

    /**
     * Get the signatureOverrides property: List of specific signatures states.
     * 
     * @return the signatureOverrides value.
     */
    public List<FirewallPolicyIntrusionDetectionSignatureSpecification> signatureOverrides() {
        return this.signatureOverrides;
    }

    /**
     * Set the signatureOverrides property: List of specific signatures states.
     * 
     * @param signatureOverrides the signatureOverrides value to set.
     * @return the FirewallPolicyIntrusionDetectionConfiguration object itself.
     */
    public FirewallPolicyIntrusionDetectionConfiguration
        withSignatureOverrides(List<FirewallPolicyIntrusionDetectionSignatureSpecification> signatureOverrides) {
        this.signatureOverrides = signatureOverrides;
        return this;
    }

    /**
     * Get the bypassTrafficSettings property: List of rules for traffic to bypass.
     * 
     * @return the bypassTrafficSettings value.
     */
    public List<FirewallPolicyIntrusionDetectionBypassTrafficSpecifications> bypassTrafficSettings() {
        return this.bypassTrafficSettings;
    }

    /**
     * Set the bypassTrafficSettings property: List of rules for traffic to bypass.
     * 
     * @param bypassTrafficSettings the bypassTrafficSettings value to set.
     * @return the FirewallPolicyIntrusionDetectionConfiguration object itself.
     */
    public FirewallPolicyIntrusionDetectionConfiguration withBypassTrafficSettings(
        List<FirewallPolicyIntrusionDetectionBypassTrafficSpecifications> bypassTrafficSettings) {
        this.bypassTrafficSettings = bypassTrafficSettings;
        return this;
    }

    /**
     * Get the privateRanges property: IDPS Private IP address ranges are used to identify traffic direction (i.e.
     * inbound, outbound, etc.). By default, only ranges defined by IANA RFC 1918 are considered private IP addresses.
     * To modify default ranges, specify your Private IP address ranges with this property.
     * 
     * @return the privateRanges value.
     */
    public List<String> privateRanges() {
        return this.privateRanges;
    }

    /**
     * Set the privateRanges property: IDPS Private IP address ranges are used to identify traffic direction (i.e.
     * inbound, outbound, etc.). By default, only ranges defined by IANA RFC 1918 are considered private IP addresses.
     * To modify default ranges, specify your Private IP address ranges with this property.
     * 
     * @param privateRanges the privateRanges value to set.
     * @return the FirewallPolicyIntrusionDetectionConfiguration object itself.
     */
    public FirewallPolicyIntrusionDetectionConfiguration withPrivateRanges(List<String> privateRanges) {
        this.privateRanges = privateRanges;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (signatureOverrides() != null) {
            signatureOverrides().forEach(e -> e.validate());
        }
        if (bypassTrafficSettings() != null) {
            bypassTrafficSettings().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("signatureOverrides", this.signatureOverrides,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("bypassTrafficSettings", this.bypassTrafficSettings,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("privateRanges", this.privateRanges,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FirewallPolicyIntrusionDetectionConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FirewallPolicyIntrusionDetectionConfiguration if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FirewallPolicyIntrusionDetectionConfiguration.
     */
    public static FirewallPolicyIntrusionDetectionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FirewallPolicyIntrusionDetectionConfiguration deserializedFirewallPolicyIntrusionDetectionConfiguration
                = new FirewallPolicyIntrusionDetectionConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("signatureOverrides".equals(fieldName)) {
                    List<FirewallPolicyIntrusionDetectionSignatureSpecification> signatureOverrides = reader
                        .readArray(reader1 -> FirewallPolicyIntrusionDetectionSignatureSpecification.fromJson(reader1));
                    deserializedFirewallPolicyIntrusionDetectionConfiguration.signatureOverrides = signatureOverrides;
                } else if ("bypassTrafficSettings".equals(fieldName)) {
                    List<FirewallPolicyIntrusionDetectionBypassTrafficSpecifications> bypassTrafficSettings
                        = reader.readArray(
                            reader1 -> FirewallPolicyIntrusionDetectionBypassTrafficSpecifications.fromJson(reader1));
                    deserializedFirewallPolicyIntrusionDetectionConfiguration.bypassTrafficSettings
                        = bypassTrafficSettings;
                } else if ("privateRanges".equals(fieldName)) {
                    List<String> privateRanges = reader.readArray(reader1 -> reader1.getString());
                    deserializedFirewallPolicyIntrusionDetectionConfiguration.privateRanges = privateRanges;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFirewallPolicyIntrusionDetectionConfiguration;
        });
    }
}
