// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * IP traffic information.
 */
@Fluent
public final class IpTraffic implements JsonSerializable<IpTraffic> {
    /*
     * List of source IP addresses of the traffic..
     */
    private List<String> sourceIps;

    /*
     * List of destination IP addresses of the traffic..
     */
    private List<String> destinationIps;

    /*
     * The source ports of the traffic.
     */
    private List<String> sourcePorts;

    /*
     * The destination ports of the traffic.
     */
    private List<String> destinationPorts;

    /*
     * The protocols property.
     */
    private List<NetworkProtocol> protocols;

    /**
     * Creates an instance of IpTraffic class.
     */
    public IpTraffic() {
    }

    /**
     * Get the sourceIps property: List of source IP addresses of the traffic..
     * 
     * @return the sourceIps value.
     */
    public List<String> sourceIps() {
        return this.sourceIps;
    }

    /**
     * Set the sourceIps property: List of source IP addresses of the traffic..
     * 
     * @param sourceIps the sourceIps value to set.
     * @return the IpTraffic object itself.
     */
    public IpTraffic withSourceIps(List<String> sourceIps) {
        this.sourceIps = sourceIps;
        return this;
    }

    /**
     * Get the destinationIps property: List of destination IP addresses of the traffic..
     * 
     * @return the destinationIps value.
     */
    public List<String> destinationIps() {
        return this.destinationIps;
    }

    /**
     * Set the destinationIps property: List of destination IP addresses of the traffic..
     * 
     * @param destinationIps the destinationIps value to set.
     * @return the IpTraffic object itself.
     */
    public IpTraffic withDestinationIps(List<String> destinationIps) {
        this.destinationIps = destinationIps;
        return this;
    }

    /**
     * Get the sourcePorts property: The source ports of the traffic.
     * 
     * @return the sourcePorts value.
     */
    public List<String> sourcePorts() {
        return this.sourcePorts;
    }

    /**
     * Set the sourcePorts property: The source ports of the traffic.
     * 
     * @param sourcePorts the sourcePorts value to set.
     * @return the IpTraffic object itself.
     */
    public IpTraffic withSourcePorts(List<String> sourcePorts) {
        this.sourcePorts = sourcePorts;
        return this;
    }

    /**
     * Get the destinationPorts property: The destination ports of the traffic.
     * 
     * @return the destinationPorts value.
     */
    public List<String> destinationPorts() {
        return this.destinationPorts;
    }

    /**
     * Set the destinationPorts property: The destination ports of the traffic.
     * 
     * @param destinationPorts the destinationPorts value to set.
     * @return the IpTraffic object itself.
     */
    public IpTraffic withDestinationPorts(List<String> destinationPorts) {
        this.destinationPorts = destinationPorts;
        return this;
    }

    /**
     * Get the protocols property: The protocols property.
     * 
     * @return the protocols value.
     */
    public List<NetworkProtocol> protocols() {
        return this.protocols;
    }

    /**
     * Set the protocols property: The protocols property.
     * 
     * @param protocols the protocols value to set.
     * @return the IpTraffic object itself.
     */
    public IpTraffic withProtocols(List<NetworkProtocol> protocols) {
        this.protocols = protocols;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceIps() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property sourceIps in model IpTraffic"));
        }
        if (destinationIps() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property destinationIps in model IpTraffic"));
        }
        if (sourcePorts() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property sourcePorts in model IpTraffic"));
        }
        if (destinationPorts() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property destinationPorts in model IpTraffic"));
        }
        if (protocols() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property protocols in model IpTraffic"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(IpTraffic.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("sourceIps", this.sourceIps, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationIps", this.destinationIps,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("sourcePorts", this.sourcePorts, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationPorts", this.destinationPorts,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("protocols", this.protocols,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpTraffic from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpTraffic if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IpTraffic.
     */
    public static IpTraffic fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpTraffic deserializedIpTraffic = new IpTraffic();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceIps".equals(fieldName)) {
                    List<String> sourceIps = reader.readArray(reader1 -> reader1.getString());
                    deserializedIpTraffic.sourceIps = sourceIps;
                } else if ("destinationIps".equals(fieldName)) {
                    List<String> destinationIps = reader.readArray(reader1 -> reader1.getString());
                    deserializedIpTraffic.destinationIps = destinationIps;
                } else if ("sourcePorts".equals(fieldName)) {
                    List<String> sourcePorts = reader.readArray(reader1 -> reader1.getString());
                    deserializedIpTraffic.sourcePorts = sourcePorts;
                } else if ("destinationPorts".equals(fieldName)) {
                    List<String> destinationPorts = reader.readArray(reader1 -> reader1.getString());
                    deserializedIpTraffic.destinationPorts = destinationPorts;
                } else if ("protocols".equals(fieldName)) {
                    List<NetworkProtocol> protocols
                        = reader.readArray(reader1 -> NetworkProtocol.fromString(reader1.getString()));
                    deserializedIpTraffic.protocols = protocols;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpTraffic;
        });
    }
}
