// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Network security rules evaluation result.
 */
@Fluent
public final class NetworkSecurityRulesEvaluationResult
    implements JsonSerializable<NetworkSecurityRulesEvaluationResult> {
    /*
     * Name of the network security rule.
     */
    private String name;

    /*
     * Value indicating whether protocol is matched.
     */
    private Boolean protocolMatched;

    /*
     * Value indicating whether source is matched.
     */
    private Boolean sourceMatched;

    /*
     * Value indicating whether source port is matched.
     */
    private Boolean sourcePortMatched;

    /*
     * Value indicating whether destination is matched.
     */
    private Boolean destinationMatched;

    /*
     * Value indicating whether destination port is matched.
     */
    private Boolean destinationPortMatched;

    /**
     * Creates an instance of NetworkSecurityRulesEvaluationResult class.
     */
    public NetworkSecurityRulesEvaluationResult() {
    }

    /**
     * Get the name property: Name of the network security rule.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the network security rule.
     * 
     * @param name the name value to set.
     * @return the NetworkSecurityRulesEvaluationResult object itself.
     */
    public NetworkSecurityRulesEvaluationResult withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the protocolMatched property: Value indicating whether protocol is matched.
     * 
     * @return the protocolMatched value.
     */
    public Boolean protocolMatched() {
        return this.protocolMatched;
    }

    /**
     * Set the protocolMatched property: Value indicating whether protocol is matched.
     * 
     * @param protocolMatched the protocolMatched value to set.
     * @return the NetworkSecurityRulesEvaluationResult object itself.
     */
    public NetworkSecurityRulesEvaluationResult withProtocolMatched(Boolean protocolMatched) {
        this.protocolMatched = protocolMatched;
        return this;
    }

    /**
     * Get the sourceMatched property: Value indicating whether source is matched.
     * 
     * @return the sourceMatched value.
     */
    public Boolean sourceMatched() {
        return this.sourceMatched;
    }

    /**
     * Set the sourceMatched property: Value indicating whether source is matched.
     * 
     * @param sourceMatched the sourceMatched value to set.
     * @return the NetworkSecurityRulesEvaluationResult object itself.
     */
    public NetworkSecurityRulesEvaluationResult withSourceMatched(Boolean sourceMatched) {
        this.sourceMatched = sourceMatched;
        return this;
    }

    /**
     * Get the sourcePortMatched property: Value indicating whether source port is matched.
     * 
     * @return the sourcePortMatched value.
     */
    public Boolean sourcePortMatched() {
        return this.sourcePortMatched;
    }

    /**
     * Set the sourcePortMatched property: Value indicating whether source port is matched.
     * 
     * @param sourcePortMatched the sourcePortMatched value to set.
     * @return the NetworkSecurityRulesEvaluationResult object itself.
     */
    public NetworkSecurityRulesEvaluationResult withSourcePortMatched(Boolean sourcePortMatched) {
        this.sourcePortMatched = sourcePortMatched;
        return this;
    }

    /**
     * Get the destinationMatched property: Value indicating whether destination is matched.
     * 
     * @return the destinationMatched value.
     */
    public Boolean destinationMatched() {
        return this.destinationMatched;
    }

    /**
     * Set the destinationMatched property: Value indicating whether destination is matched.
     * 
     * @param destinationMatched the destinationMatched value to set.
     * @return the NetworkSecurityRulesEvaluationResult object itself.
     */
    public NetworkSecurityRulesEvaluationResult withDestinationMatched(Boolean destinationMatched) {
        this.destinationMatched = destinationMatched;
        return this;
    }

    /**
     * Get the destinationPortMatched property: Value indicating whether destination port is matched.
     * 
     * @return the destinationPortMatched value.
     */
    public Boolean destinationPortMatched() {
        return this.destinationPortMatched;
    }

    /**
     * Set the destinationPortMatched property: Value indicating whether destination port is matched.
     * 
     * @param destinationPortMatched the destinationPortMatched value to set.
     * @return the NetworkSecurityRulesEvaluationResult object itself.
     */
    public NetworkSecurityRulesEvaluationResult withDestinationPortMatched(Boolean destinationPortMatched) {
        this.destinationPortMatched = destinationPortMatched;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("protocolMatched", this.protocolMatched);
        jsonWriter.writeBooleanField("sourceMatched", this.sourceMatched);
        jsonWriter.writeBooleanField("sourcePortMatched", this.sourcePortMatched);
        jsonWriter.writeBooleanField("destinationMatched", this.destinationMatched);
        jsonWriter.writeBooleanField("destinationPortMatched", this.destinationPortMatched);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkSecurityRulesEvaluationResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkSecurityRulesEvaluationResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkSecurityRulesEvaluationResult.
     */
    public static NetworkSecurityRulesEvaluationResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityRulesEvaluationResult deserializedNetworkSecurityRulesEvaluationResult
                = new NetworkSecurityRulesEvaluationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedNetworkSecurityRulesEvaluationResult.name = reader.getString();
                } else if ("protocolMatched".equals(fieldName)) {
                    deserializedNetworkSecurityRulesEvaluationResult.protocolMatched
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("sourceMatched".equals(fieldName)) {
                    deserializedNetworkSecurityRulesEvaluationResult.sourceMatched
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("sourcePortMatched".equals(fieldName)) {
                    deserializedNetworkSecurityRulesEvaluationResult.sourcePortMatched
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("destinationMatched".equals(fieldName)) {
                    deserializedNetworkSecurityRulesEvaluationResult.destinationMatched
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("destinationPortMatched".equals(fieldName)) {
                    deserializedNetworkSecurityRulesEvaluationResult.destinationPortMatched
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkSecurityRulesEvaluationResult;
        });
    }
}
