// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * List of P2S Vpn connection health request.
 */
@Fluent
public final class P2SVpnConnectionHealthRequest implements JsonSerializable<P2SVpnConnectionHealthRequest> {
    /*
     * The list of p2s vpn user names whose p2s vpn connection detailed health to retrieve for.
     */
    private List<String> vpnUserNamesFilter;

    /*
     * The sas-url to download the P2S Vpn connection health detail.
     */
    private String outputBlobSasUrl;

    /**
     * Creates an instance of P2SVpnConnectionHealthRequest class.
     */
    public P2SVpnConnectionHealthRequest() {
    }

    /**
     * Get the vpnUserNamesFilter property: The list of p2s vpn user names whose p2s vpn connection detailed health to
     * retrieve for.
     * 
     * @return the vpnUserNamesFilter value.
     */
    public List<String> vpnUserNamesFilter() {
        return this.vpnUserNamesFilter;
    }

    /**
     * Set the vpnUserNamesFilter property: The list of p2s vpn user names whose p2s vpn connection detailed health to
     * retrieve for.
     * 
     * @param vpnUserNamesFilter the vpnUserNamesFilter value to set.
     * @return the P2SVpnConnectionHealthRequest object itself.
     */
    public P2SVpnConnectionHealthRequest withVpnUserNamesFilter(List<String> vpnUserNamesFilter) {
        this.vpnUserNamesFilter = vpnUserNamesFilter;
        return this;
    }

    /**
     * Get the outputBlobSasUrl property: The sas-url to download the P2S Vpn connection health detail.
     * 
     * @return the outputBlobSasUrl value.
     */
    public String outputBlobSasUrl() {
        return this.outputBlobSasUrl;
    }

    /**
     * Set the outputBlobSasUrl property: The sas-url to download the P2S Vpn connection health detail.
     * 
     * @param outputBlobSasUrl the outputBlobSasUrl value to set.
     * @return the P2SVpnConnectionHealthRequest object itself.
     */
    public P2SVpnConnectionHealthRequest withOutputBlobSasUrl(String outputBlobSasUrl) {
        this.outputBlobSasUrl = outputBlobSasUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("vpnUserNamesFilter", this.vpnUserNamesFilter,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("outputBlobSasUrl", this.outputBlobSasUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of P2SVpnConnectionHealthRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of P2SVpnConnectionHealthRequest if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the P2SVpnConnectionHealthRequest.
     */
    public static P2SVpnConnectionHealthRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            P2SVpnConnectionHealthRequest deserializedP2SVpnConnectionHealthRequest
                = new P2SVpnConnectionHealthRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vpnUserNamesFilter".equals(fieldName)) {
                    List<String> vpnUserNamesFilter = reader.readArray(reader1 -> reader1.getString());
                    deserializedP2SVpnConnectionHealthRequest.vpnUserNamesFilter = vpnUserNamesFilter;
                } else if ("outputBlobSasUrl".equals(fieldName)) {
                    deserializedP2SVpnConnectionHealthRequest.outputBlobSasUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedP2SVpnConnectionHealthRequest;
        });
    }
}
