// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.PeerExpressRouteCircuitConnectionInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for ListPeeredConnections API service call retrieves all global reach peer circuit connections that belongs
 * to a Private Peering for an ExpressRouteCircuit.
 */
@Fluent
public final class PeerExpressRouteCircuitConnectionListResult
    implements JsonSerializable<PeerExpressRouteCircuitConnectionListResult> {
    /*
     * The global reach peer circuit connection associated with Private Peering in an ExpressRoute Circuit.
     */
    private List<PeerExpressRouteCircuitConnectionInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of PeerExpressRouteCircuitConnectionListResult class.
     */
    public PeerExpressRouteCircuitConnectionListResult() {
    }

    /**
     * Get the value property: The global reach peer circuit connection associated with Private Peering in an
     * ExpressRoute Circuit.
     * 
     * @return the value value.
     */
    public List<PeerExpressRouteCircuitConnectionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The global reach peer circuit connection associated with Private Peering in an
     * ExpressRoute Circuit.
     * 
     * @param value the value value to set.
     * @return the PeerExpressRouteCircuitConnectionListResult object itself.
     */
    public PeerExpressRouteCircuitConnectionListResult withValue(List<PeerExpressRouteCircuitConnectionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the PeerExpressRouteCircuitConnectionListResult object itself.
     */
    public PeerExpressRouteCircuitConnectionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PeerExpressRouteCircuitConnectionListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PeerExpressRouteCircuitConnectionListResult if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PeerExpressRouteCircuitConnectionListResult.
     */
    public static PeerExpressRouteCircuitConnectionListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PeerExpressRouteCircuitConnectionListResult deserializedPeerExpressRouteCircuitConnectionListResult
                = new PeerExpressRouteCircuitConnectionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<PeerExpressRouteCircuitConnectionInner> value
                        = reader.readArray(reader1 -> PeerExpressRouteCircuitConnectionInner.fromJson(reader1));
                    deserializedPeerExpressRouteCircuitConnectionListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedPeerExpressRouteCircuitConnectionListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPeerExpressRouteCircuitConnectionListResult;
        });
    }
}
