// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The list of RouteTables to advertise the routes to.
 */
@Fluent
public final class PropagatedRouteTable implements JsonSerializable<PropagatedRouteTable> {
    /*
     * The list of labels.
     */
    private List<String> labels;

    /*
     * The list of resource ids of all the RouteTables.
     */
    private List<SubResource> ids;

    /**
     * Creates an instance of PropagatedRouteTable class.
     */
    public PropagatedRouteTable() {
    }

    /**
     * Get the labels property: The list of labels.
     * 
     * @return the labels value.
     */
    public List<String> labels() {
        return this.labels;
    }

    /**
     * Set the labels property: The list of labels.
     * 
     * @param labels the labels value to set.
     * @return the PropagatedRouteTable object itself.
     */
    public PropagatedRouteTable withLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    /**
     * Get the ids property: The list of resource ids of all the RouteTables.
     * 
     * @return the ids value.
     */
    public List<SubResource> ids() {
        return this.ids;
    }

    /**
     * Set the ids property: The list of resource ids of all the RouteTables.
     * 
     * @param ids the ids value to set.
     * @return the PropagatedRouteTable object itself.
     */
    public PropagatedRouteTable withIds(List<SubResource> ids) {
        this.ids = ids;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("labels", this.labels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("ids", this.ids, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PropagatedRouteTable from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PropagatedRouteTable if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PropagatedRouteTable.
     */
    public static PropagatedRouteTable fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PropagatedRouteTable deserializedPropagatedRouteTable = new PropagatedRouteTable();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("labels".equals(fieldName)) {
                    List<String> labels = reader.readArray(reader1 -> reader1.getString());
                    deserializedPropagatedRouteTable.labels = labels;
                } else if ("ids".equals(fieldName)) {
                    List<SubResource> ids = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedPropagatedRouteTable.ids = ids;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPropagatedRouteTable;
        });
    }
}
