// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ReachabilityAnalysisRunInner;
import java.io.IOException;
import java.util.List;

/**
 * A list of Reachability Analysis Run.
 */
@Fluent
public final class ReachabilityAnalysisRunListResult implements JsonSerializable<ReachabilityAnalysisRunListResult> {
    /*
     * Gets a page of Reachability Analysis Runs.
     */
    private List<ReachabilityAnalysisRunInner> value;

    /*
     * Gets the URL to get the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ReachabilityAnalysisRunListResult class.
     */
    public ReachabilityAnalysisRunListResult() {
    }

    /**
     * Get the value property: Gets a page of Reachability Analysis Runs.
     * 
     * @return the value value.
     */
    public List<ReachabilityAnalysisRunInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Gets a page of Reachability Analysis Runs.
     * 
     * @param value the value value to set.
     * @return the ReachabilityAnalysisRunListResult object itself.
     */
    public ReachabilityAnalysisRunListResult withValue(List<ReachabilityAnalysisRunInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Gets the URL to get the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Gets the URL to get the next page of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ReachabilityAnalysisRunListResult object itself.
     */
    public ReachabilityAnalysisRunListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReachabilityAnalysisRunListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReachabilityAnalysisRunListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ReachabilityAnalysisRunListResult.
     */
    public static ReachabilityAnalysisRunListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReachabilityAnalysisRunListResult deserializedReachabilityAnalysisRunListResult
                = new ReachabilityAnalysisRunListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ReachabilityAnalysisRunInner> value
                        = reader.readArray(reader1 -> ReachabilityAnalysisRunInner.fromJson(reader1));
                    deserializedReachabilityAnalysisRunListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReachabilityAnalysisRunListResult;
        });
    }
}
