// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The service endpoint properties.
 */
@Fluent
public final class ServiceEndpointPropertiesFormat implements JsonSerializable<ServiceEndpointPropertiesFormat> {
    /*
     * The type of the endpoint service.
     */
    private String service;

    /*
     * SubResource as network identifier.
     */
    private SubResource networkIdentifier;

    /*
     * A list of locations.
     */
    private List<String> locations;

    /*
     * The provisioning state of the service endpoint resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ServiceEndpointPropertiesFormat class.
     */
    public ServiceEndpointPropertiesFormat() {
    }

    /**
     * Get the service property: The type of the endpoint service.
     * 
     * @return the service value.
     */
    public String service() {
        return this.service;
    }

    /**
     * Set the service property: The type of the endpoint service.
     * 
     * @param service the service value to set.
     * @return the ServiceEndpointPropertiesFormat object itself.
     */
    public ServiceEndpointPropertiesFormat withService(String service) {
        this.service = service;
        return this;
    }

    /**
     * Get the networkIdentifier property: SubResource as network identifier.
     * 
     * @return the networkIdentifier value.
     */
    public SubResource networkIdentifier() {
        return this.networkIdentifier;
    }

    /**
     * Set the networkIdentifier property: SubResource as network identifier.
     * 
     * @param networkIdentifier the networkIdentifier value to set.
     * @return the ServiceEndpointPropertiesFormat object itself.
     */
    public ServiceEndpointPropertiesFormat withNetworkIdentifier(SubResource networkIdentifier) {
        this.networkIdentifier = networkIdentifier;
        return this;
    }

    /**
     * Get the locations property: A list of locations.
     * 
     * @return the locations value.
     */
    public List<String> locations() {
        return this.locations;
    }

    /**
     * Set the locations property: A list of locations.
     * 
     * @param locations the locations value to set.
     * @return the ServiceEndpointPropertiesFormat object itself.
     */
    public ServiceEndpointPropertiesFormat withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the service endpoint resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("service", this.service);
        jsonWriter.writeJsonField("networkIdentifier", this.networkIdentifier);
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServiceEndpointPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServiceEndpointPropertiesFormat if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServiceEndpointPropertiesFormat.
     */
    public static ServiceEndpointPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceEndpointPropertiesFormat deserializedServiceEndpointPropertiesFormat
                = new ServiceEndpointPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("service".equals(fieldName)) {
                    deserializedServiceEndpointPropertiesFormat.service = reader.getString();
                } else if ("networkIdentifier".equals(fieldName)) {
                    deserializedServiceEndpointPropertiesFormat.networkIdentifier = SubResource.fromJson(reader);
                } else if ("locations".equals(fieldName)) {
                    List<String> locations = reader.readArray(reader1 -> reader1.getString());
                    deserializedServiceEndpointPropertiesFormat.locations = locations;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedServiceEndpointPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServiceEndpointPropertiesFormat;
        });
    }
}
