// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Properties of the service tag information.
 */
@Immutable
public final class ServiceTagInformationPropertiesFormat
    implements JsonSerializable<ServiceTagInformationPropertiesFormat> {
    /*
     * The iteration number of service tag.
     */
    private String changeNumber;

    /*
     * The region of service tag.
     */
    private String region;

    /*
     * The name of system service.
     */
    private String systemService;

    /*
     * The list of IP address prefixes.
     */
    private List<String> addressPrefixes;

    /*
     * The state of the service tag.
     */
    private String state;

    /**
     * Creates an instance of ServiceTagInformationPropertiesFormat class.
     */
    public ServiceTagInformationPropertiesFormat() {
    }

    /**
     * Get the changeNumber property: The iteration number of service tag.
     * 
     * @return the changeNumber value.
     */
    public String changeNumber() {
        return this.changeNumber;
    }

    /**
     * Get the region property: The region of service tag.
     * 
     * @return the region value.
     */
    public String region() {
        return this.region;
    }

    /**
     * Get the systemService property: The name of system service.
     * 
     * @return the systemService value.
     */
    public String systemService() {
        return this.systemService;
    }

    /**
     * Get the addressPrefixes property: The list of IP address prefixes.
     * 
     * @return the addressPrefixes value.
     */
    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    /**
     * Get the state property: The state of the service tag.
     * 
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServiceTagInformationPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServiceTagInformationPropertiesFormat if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServiceTagInformationPropertiesFormat.
     */
    public static ServiceTagInformationPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceTagInformationPropertiesFormat deserializedServiceTagInformationPropertiesFormat
                = new ServiceTagInformationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("changeNumber".equals(fieldName)) {
                    deserializedServiceTagInformationPropertiesFormat.changeNumber = reader.getString();
                } else if ("region".equals(fieldName)) {
                    deserializedServiceTagInformationPropertiesFormat.region = reader.getString();
                } else if ("systemService".equals(fieldName)) {
                    deserializedServiceTagInformationPropertiesFormat.systemService = reader.getString();
                } else if ("addressPrefixes".equals(fieldName)) {
                    List<String> addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedServiceTagInformationPropertiesFormat.addressPrefixes = addressPrefixes;
                } else if ("state".equals(fieldName)) {
                    deserializedServiceTagInformationPropertiesFormat.state = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServiceTagInformationPropertiesFormat;
        });
    }
}
