// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters for SharedKey.
 */
@Fluent
public final class SharedKeyProperties implements JsonSerializable<SharedKeyProperties> {
    /*
     * The value of the shared key for the vpn link connection.
     */
    private String sharedKey;

    /*
     * The length of the shared key for the vpn link connection.
     */
    private Integer sharedKeyLength;

    /*
     * The provisioning state of the SharedKey resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of SharedKeyProperties class.
     */
    public SharedKeyProperties() {
    }

    /**
     * Get the sharedKey property: The value of the shared key for the vpn link connection.
     * 
     * @return the sharedKey value.
     */
    public String sharedKey() {
        return this.sharedKey;
    }

    /**
     * Set the sharedKey property: The value of the shared key for the vpn link connection.
     * 
     * @param sharedKey the sharedKey value to set.
     * @return the SharedKeyProperties object itself.
     */
    public SharedKeyProperties withSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
        return this;
    }

    /**
     * Get the sharedKeyLength property: The length of the shared key for the vpn link connection.
     * 
     * @return the sharedKeyLength value.
     */
    public Integer sharedKeyLength() {
        return this.sharedKeyLength;
    }

    /**
     * Set the sharedKeyLength property: The length of the shared key for the vpn link connection.
     * 
     * @param sharedKeyLength the sharedKeyLength value to set.
     * @return the SharedKeyProperties object itself.
     */
    public SharedKeyProperties withSharedKeyLength(Integer sharedKeyLength) {
        this.sharedKeyLength = sharedKeyLength;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the SharedKey resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sharedKey", this.sharedKey);
        jsonWriter.writeNumberField("sharedKeyLength", this.sharedKeyLength);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SharedKeyProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SharedKeyProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SharedKeyProperties.
     */
    public static SharedKeyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SharedKeyProperties deserializedSharedKeyProperties = new SharedKeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sharedKey".equals(fieldName)) {
                    deserializedSharedKeyProperties.sharedKey = reader.getString();
                } else if ("sharedKeyLength".equals(fieldName)) {
                    deserializedSharedKeyProperties.sharedKeyLength = reader.getNullable(JsonReader::getInt);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedSharedKeyProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSharedKeyProperties;
        });
    }
}
