// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the VerifierWorkspace update properties.
 */
@Fluent
public final class VerifierWorkspaceUpdateProperties implements JsonSerializable<VerifierWorkspaceUpdateProperties> {
    /*
     * The description property.
     */
    private String description;

    /**
     * Creates an instance of VerifierWorkspaceUpdateProperties class.
     */
    public VerifierWorkspaceUpdateProperties() {
    }

    /**
     * Get the description property: The description property.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     * 
     * @param description the description value to set.
     * @return the VerifierWorkspaceUpdateProperties object itself.
     */
    public VerifierWorkspaceUpdateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VerifierWorkspaceUpdateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VerifierWorkspaceUpdateProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VerifierWorkspaceUpdateProperties.
     */
    public static VerifierWorkspaceUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VerifierWorkspaceUpdateProperties deserializedVerifierWorkspaceUpdateProperties
                = new VerifierWorkspaceUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedVerifierWorkspaceUpdateProperties.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVerifierWorkspaceUpdateProperties;
        });
    }
}
