// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * VirtualHubRouteTableV2 route.
 */
@Fluent
public final class VirtualHubRouteV2 implements JsonSerializable<VirtualHubRouteV2> {
    /*
     * The type of destinations.
     */
    private String destinationType;

    /*
     * List of all destinations.
     */
    private List<String> destinations;

    /*
     * The type of next hops.
     */
    private String nextHopType;

    /*
     * NextHops ip address.
     */
    private List<String> nextHops;

    /**
     * Creates an instance of VirtualHubRouteV2 class.
     */
    public VirtualHubRouteV2() {
    }

    /**
     * Get the destinationType property: The type of destinations.
     * 
     * @return the destinationType value.
     */
    public String destinationType() {
        return this.destinationType;
    }

    /**
     * Set the destinationType property: The type of destinations.
     * 
     * @param destinationType the destinationType value to set.
     * @return the VirtualHubRouteV2 object itself.
     */
    public VirtualHubRouteV2 withDestinationType(String destinationType) {
        this.destinationType = destinationType;
        return this;
    }

    /**
     * Get the destinations property: List of all destinations.
     * 
     * @return the destinations value.
     */
    public List<String> destinations() {
        return this.destinations;
    }

    /**
     * Set the destinations property: List of all destinations.
     * 
     * @param destinations the destinations value to set.
     * @return the VirtualHubRouteV2 object itself.
     */
    public VirtualHubRouteV2 withDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    /**
     * Get the nextHopType property: The type of next hops.
     * 
     * @return the nextHopType value.
     */
    public String nextHopType() {
        return this.nextHopType;
    }

    /**
     * Set the nextHopType property: The type of next hops.
     * 
     * @param nextHopType the nextHopType value to set.
     * @return the VirtualHubRouteV2 object itself.
     */
    public VirtualHubRouteV2 withNextHopType(String nextHopType) {
        this.nextHopType = nextHopType;
        return this;
    }

    /**
     * Get the nextHops property: NextHops ip address.
     * 
     * @return the nextHops value.
     */
    public List<String> nextHops() {
        return this.nextHops;
    }

    /**
     * Set the nextHops property: NextHops ip address.
     * 
     * @param nextHops the nextHops value to set.
     * @return the VirtualHubRouteV2 object itself.
     */
    public VirtualHubRouteV2 withNextHops(List<String> nextHops) {
        this.nextHops = nextHops;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("destinationType", this.destinationType);
        jsonWriter.writeArrayField("destinations", this.destinations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("nextHopType", this.nextHopType);
        jsonWriter.writeArrayField("nextHops", this.nextHops, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualHubRouteV2 from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualHubRouteV2 if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualHubRouteV2.
     */
    public static VirtualHubRouteV2 fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualHubRouteV2 deserializedVirtualHubRouteV2 = new VirtualHubRouteV2();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("destinationType".equals(fieldName)) {
                    deserializedVirtualHubRouteV2.destinationType = reader.getString();
                } else if ("destinations".equals(fieldName)) {
                    List<String> destinations = reader.readArray(reader1 -> reader1.getString());
                    deserializedVirtualHubRouteV2.destinations = destinations;
                } else if ("nextHopType".equals(fieldName)) {
                    deserializedVirtualHubRouteV2.nextHopType = reader.getString();
                } else if ("nextHops".equals(fieldName)) {
                    List<String> nextHops = reader.readArray(reader1 -> reader1.getString());
                    deserializedVirtualHubRouteV2.nextHops = nextHops;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualHubRouteV2;
        });
    }
}
