// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A reference to VirtualNetworkGateway or LocalNetworkGateway resource.
 */
@Fluent
public final class VirtualNetworkConnectionGatewayReference
    implements JsonSerializable<VirtualNetworkConnectionGatewayReference> {
    /*
     * The ID of VirtualNetworkGateway or LocalNetworkGateway resource.
     */
    private String id;

    /**
     * Creates an instance of VirtualNetworkConnectionGatewayReference class.
     */
    public VirtualNetworkConnectionGatewayReference() {
    }

    /**
     * Get the id property: The ID of VirtualNetworkGateway or LocalNetworkGateway resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The ID of VirtualNetworkGateway or LocalNetworkGateway resource.
     * 
     * @param id the id value to set.
     * @return the VirtualNetworkConnectionGatewayReference object itself.
     */
    public VirtualNetworkConnectionGatewayReference withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property id in model VirtualNetworkConnectionGatewayReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkConnectionGatewayReference.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkConnectionGatewayReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkConnectionGatewayReference if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VirtualNetworkConnectionGatewayReference.
     */
    public static VirtualNetworkConnectionGatewayReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkConnectionGatewayReference deserializedVirtualNetworkConnectionGatewayReference
                = new VirtualNetworkConnectionGatewayReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedVirtualNetworkConnectionGatewayReference.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkConnectionGatewayReference;
        });
    }
}
