// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * VpnClientConfiguration for P2S client.
 */
@Fluent
public final class VpnClientConfiguration implements JsonSerializable<VpnClientConfiguration> {
    /*
     * The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    private AddressSpace vpnClientAddressPool;

    /*
     * VpnClientRootCertificate for virtual network gateway.
     */
    private List<VpnClientRootCertificate> vpnClientRootCertificates;

    /*
     * VpnClientRevokedCertificate for Virtual network gateway.
     */
    private List<VpnClientRevokedCertificate> vpnClientRevokedCertificates;

    /*
     * VpnClientProtocols for Virtual network gateway.
     */
    private List<VpnClientProtocol> vpnClientProtocols;

    /*
     * VPN authentication types for the virtual network gateway..
     */
    private List<VpnAuthenticationType> vpnAuthenticationTypes;

    /*
     * VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    private List<IpsecPolicy> vpnClientIpsecPolicies;

    /*
     * The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
     */
    private String radiusServerAddress;

    /*
     * The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
     */
    private String radiusServerSecret;

    /*
     * The radiusServers property for multiple radius server configuration.
     */
    private List<RadiusServer> radiusServers;

    /*
     * The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD
     * authentication.
     */
    private String aadTenant;

    /*
     * The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD
     * authentication.
     */
    private String aadAudience;

    /*
     * The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD
     * authentication.
     */
    private String aadIssuer;

    /*
     * per ip address pool connection policy for virtual network gateway P2S client.
     */
    private List<VngClientConnectionConfiguration> vngClientConnectionConfigurations;

    /**
     * Creates an instance of VpnClientConfiguration class.
     */
    public VpnClientConfiguration() {
    }

    /**
     * Get the vpnClientAddressPool property: The reference to the address space resource which represents Address space
     * for P2S VpnClient.
     * 
     * @return the vpnClientAddressPool value.
     */
    public AddressSpace vpnClientAddressPool() {
        return this.vpnClientAddressPool;
    }

    /**
     * Set the vpnClientAddressPool property: The reference to the address space resource which represents Address space
     * for P2S VpnClient.
     * 
     * @param vpnClientAddressPool the vpnClientAddressPool value to set.
     * @return the VpnClientConfiguration object itself.
     */
    public VpnClientConfiguration withVpnClientAddressPool(AddressSpace vpnClientAddressPool) {
        this.vpnClientAddressPool = vpnClientAddressPool;
        return this;
    }

    /**
     * Get the vpnClientRootCertificates property: VpnClientRootCertificate for virtual network gateway.
     * 
     * @return the vpnClientRootCertificates value.
     */
    public List<VpnClientRootCertificate> vpnClientRootCertificates() {
        return this.vpnClientRootCertificates;
    }

    /**
     * Set the vpnClientRootCertificates property: VpnClientRootCertificate for virtual network gateway.
     * 
     * @param vpnClientRootCertificates the vpnClientRootCertificates value to set.
     * @return the VpnClientConfiguration object itself.
     */
    public VpnClientConfiguration
        withVpnClientRootCertificates(List<VpnClientRootCertificate> vpnClientRootCertificates) {
        this.vpnClientRootCertificates = vpnClientRootCertificates;
        return this;
    }

    /**
     * Get the vpnClientRevokedCertificates property: VpnClientRevokedCertificate for Virtual network gateway.
     * 
     * @return the vpnClientRevokedCertificates value.
     */
    public List<VpnClientRevokedCertificate> vpnClientRevokedCertificates() {
        return this.vpnClientRevokedCertificates;
    }

    /**
     * Set the vpnClientRevokedCertificates property: VpnClientRevokedCertificate for Virtual network gateway.
     * 
     * @param vpnClientRevokedCertificates the vpnClientRevokedCertificates value to set.
     * @return the VpnClientConfiguration object itself.
     */
    public VpnClientConfiguration
        withVpnClientRevokedCertificates(List<VpnClientRevokedCertificate> vpnClientRevokedCertificates) {
        this.vpnClientRevokedCertificates = vpnClientRevokedCertificates;
        return this;
    }

    /**
     * Get the vpnClientProtocols property: VpnClientProtocols for Virtual network gateway.
     * 
     * @return the vpnClientProtocols value.
     */
    public List<VpnClientProtocol> vpnClientProtocols() {
        return this.vpnClientProtocols;
    }

    /**
     * Set the vpnClientProtocols property: VpnClientProtocols for Virtual network gateway.
     * 
     * @param vpnClientProtocols the vpnClientProtocols value to set.
     * @return the VpnClientConfiguration object itself.
     */
    public VpnClientConfiguration withVpnClientProtocols(List<VpnClientProtocol> vpnClientProtocols) {
        this.vpnClientProtocols = vpnClientProtocols;
        return this;
    }

    /**
     * Get the vpnAuthenticationTypes property: VPN authentication types for the virtual network gateway..
     * 
     * @return the vpnAuthenticationTypes value.
     */
    public List<VpnAuthenticationType> vpnAuthenticationTypes() {
        return this.vpnAuthenticationTypes;
    }

    /**
     * Set the vpnAuthenticationTypes property: VPN authentication types for the virtual network gateway..
     * 
     * @param vpnAuthenticationTypes the vpnAuthenticationTypes value to set.
     * @return the VpnClientConfiguration object itself.
     */
    public VpnClientConfiguration withVpnAuthenticationTypes(List<VpnAuthenticationType> vpnAuthenticationTypes) {
        this.vpnAuthenticationTypes = vpnAuthenticationTypes;
        return this;
    }

    /**
     * Get the vpnClientIpsecPolicies property: VpnClientIpsecPolicies for virtual network gateway P2S client.
     * 
     * @return the vpnClientIpsecPolicies value.
     */
    public List<IpsecPolicy> vpnClientIpsecPolicies() {
        return this.vpnClientIpsecPolicies;
    }

    /**
     * Set the vpnClientIpsecPolicies property: VpnClientIpsecPolicies for virtual network gateway P2S client.
     * 
     * @param vpnClientIpsecPolicies the vpnClientIpsecPolicies value to set.
     * @return the VpnClientConfiguration object itself.
     */
    public VpnClientConfiguration withVpnClientIpsecPolicies(List<IpsecPolicy> vpnClientIpsecPolicies) {
        this.vpnClientIpsecPolicies = vpnClientIpsecPolicies;
        return this;
    }

    /**
     * Get the radiusServerAddress property: The radius server address property of the VirtualNetworkGateway resource
     * for vpn client connection.
     * 
     * @return the radiusServerAddress value.
     */
    public String radiusServerAddress() {
        return this.radiusServerAddress;
    }

    /**
     * Set the radiusServerAddress property: The radius server address property of the VirtualNetworkGateway resource
     * for vpn client connection.
     * 
     * @param radiusServerAddress the radiusServerAddress value to set.
     * @return the VpnClientConfiguration object itself.
     */
    public VpnClientConfiguration withRadiusServerAddress(String radiusServerAddress) {
        this.radiusServerAddress = radiusServerAddress;
        return this;
    }

    /**
     * Get the radiusServerSecret property: The radius secret property of the VirtualNetworkGateway resource for vpn
     * client connection.
     * 
     * @return the radiusServerSecret value.
     */
    public String radiusServerSecret() {
        return this.radiusServerSecret;
    }

    /**
     * Set the radiusServerSecret property: The radius secret property of the VirtualNetworkGateway resource for vpn
     * client connection.
     * 
     * @param radiusServerSecret the radiusServerSecret value to set.
     * @return the VpnClientConfiguration object itself.
     */
    public VpnClientConfiguration withRadiusServerSecret(String radiusServerSecret) {
        this.radiusServerSecret = radiusServerSecret;
        return this;
    }

    /**
     * Get the radiusServers property: The radiusServers property for multiple radius server configuration.
     * 
     * @return the radiusServers value.
     */
    public List<RadiusServer> radiusServers() {
        return this.radiusServers;
    }

    /**
     * Set the radiusServers property: The radiusServers property for multiple radius server configuration.
     * 
     * @param radiusServers the radiusServers value to set.
     * @return the VpnClientConfiguration object itself.
     */
    public VpnClientConfiguration withRadiusServers(List<RadiusServer> radiusServers) {
        this.radiusServers = radiusServers;
        return this;
    }

    /**
     * Get the aadTenant property: The AADTenant property of the VirtualNetworkGateway resource for vpn client
     * connection used for AAD authentication.
     * 
     * @return the aadTenant value.
     */
    public String aadTenant() {
        return this.aadTenant;
    }

    /**
     * Set the aadTenant property: The AADTenant property of the VirtualNetworkGateway resource for vpn client
     * connection used for AAD authentication.
     * 
     * @param aadTenant the aadTenant value to set.
     * @return the VpnClientConfiguration object itself.
     */
    public VpnClientConfiguration withAadTenant(String aadTenant) {
        this.aadTenant = aadTenant;
        return this;
    }

    /**
     * Get the aadAudience property: The AADAudience property of the VirtualNetworkGateway resource for vpn client
     * connection used for AAD authentication.
     * 
     * @return the aadAudience value.
     */
    public String aadAudience() {
        return this.aadAudience;
    }

    /**
     * Set the aadAudience property: The AADAudience property of the VirtualNetworkGateway resource for vpn client
     * connection used for AAD authentication.
     * 
     * @param aadAudience the aadAudience value to set.
     * @return the VpnClientConfiguration object itself.
     */
    public VpnClientConfiguration withAadAudience(String aadAudience) {
        this.aadAudience = aadAudience;
        return this;
    }

    /**
     * Get the aadIssuer property: The AADIssuer property of the VirtualNetworkGateway resource for vpn client
     * connection used for AAD authentication.
     * 
     * @return the aadIssuer value.
     */
    public String aadIssuer() {
        return this.aadIssuer;
    }

    /**
     * Set the aadIssuer property: The AADIssuer property of the VirtualNetworkGateway resource for vpn client
     * connection used for AAD authentication.
     * 
     * @param aadIssuer the aadIssuer value to set.
     * @return the VpnClientConfiguration object itself.
     */
    public VpnClientConfiguration withAadIssuer(String aadIssuer) {
        this.aadIssuer = aadIssuer;
        return this;
    }

    /**
     * Get the vngClientConnectionConfigurations property: per ip address pool connection policy for virtual network
     * gateway P2S client.
     * 
     * @return the vngClientConnectionConfigurations value.
     */
    public List<VngClientConnectionConfiguration> vngClientConnectionConfigurations() {
        return this.vngClientConnectionConfigurations;
    }

    /**
     * Set the vngClientConnectionConfigurations property: per ip address pool connection policy for virtual network
     * gateway P2S client.
     * 
     * @param vngClientConnectionConfigurations the vngClientConnectionConfigurations value to set.
     * @return the VpnClientConfiguration object itself.
     */
    public VpnClientConfiguration withVngClientConnectionConfigurations(
        List<VngClientConnectionConfiguration> vngClientConnectionConfigurations) {
        this.vngClientConnectionConfigurations = vngClientConnectionConfigurations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (vpnClientAddressPool() != null) {
            vpnClientAddressPool().validate();
        }
        if (vpnClientRootCertificates() != null) {
            vpnClientRootCertificates().forEach(e -> e.validate());
        }
        if (vpnClientRevokedCertificates() != null) {
            vpnClientRevokedCertificates().forEach(e -> e.validate());
        }
        if (vpnClientIpsecPolicies() != null) {
            vpnClientIpsecPolicies().forEach(e -> e.validate());
        }
        if (radiusServers() != null) {
            radiusServers().forEach(e -> e.validate());
        }
        if (vngClientConnectionConfigurations() != null) {
            vngClientConnectionConfigurations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("vpnClientAddressPool", this.vpnClientAddressPool);
        jsonWriter.writeArrayField("vpnClientRootCertificates", this.vpnClientRootCertificates,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("vpnClientRevokedCertificates", this.vpnClientRevokedCertificates,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("vpnClientProtocols", this.vpnClientProtocols,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("vpnAuthenticationTypes", this.vpnAuthenticationTypes,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("vpnClientIpsecPolicies", this.vpnClientIpsecPolicies,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("radiusServerAddress", this.radiusServerAddress);
        jsonWriter.writeStringField("radiusServerSecret", this.radiusServerSecret);
        jsonWriter.writeArrayField("radiusServers", this.radiusServers, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("aadTenant", this.aadTenant);
        jsonWriter.writeStringField("aadAudience", this.aadAudience);
        jsonWriter.writeStringField("aadIssuer", this.aadIssuer);
        jsonWriter.writeArrayField("vngClientConnectionConfigurations", this.vngClientConnectionConfigurations,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnClientConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnClientConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnClientConfiguration.
     */
    public static VpnClientConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnClientConfiguration deserializedVpnClientConfiguration = new VpnClientConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vpnClientAddressPool".equals(fieldName)) {
                    deserializedVpnClientConfiguration.vpnClientAddressPool = AddressSpace.fromJson(reader);
                } else if ("vpnClientRootCertificates".equals(fieldName)) {
                    List<VpnClientRootCertificate> vpnClientRootCertificates
                        = reader.readArray(reader1 -> VpnClientRootCertificate.fromJson(reader1));
                    deserializedVpnClientConfiguration.vpnClientRootCertificates = vpnClientRootCertificates;
                } else if ("vpnClientRevokedCertificates".equals(fieldName)) {
                    List<VpnClientRevokedCertificate> vpnClientRevokedCertificates
                        = reader.readArray(reader1 -> VpnClientRevokedCertificate.fromJson(reader1));
                    deserializedVpnClientConfiguration.vpnClientRevokedCertificates = vpnClientRevokedCertificates;
                } else if ("vpnClientProtocols".equals(fieldName)) {
                    List<VpnClientProtocol> vpnClientProtocols
                        = reader.readArray(reader1 -> VpnClientProtocol.fromString(reader1.getString()));
                    deserializedVpnClientConfiguration.vpnClientProtocols = vpnClientProtocols;
                } else if ("vpnAuthenticationTypes".equals(fieldName)) {
                    List<VpnAuthenticationType> vpnAuthenticationTypes
                        = reader.readArray(reader1 -> VpnAuthenticationType.fromString(reader1.getString()));
                    deserializedVpnClientConfiguration.vpnAuthenticationTypes = vpnAuthenticationTypes;
                } else if ("vpnClientIpsecPolicies".equals(fieldName)) {
                    List<IpsecPolicy> vpnClientIpsecPolicies
                        = reader.readArray(reader1 -> IpsecPolicy.fromJson(reader1));
                    deserializedVpnClientConfiguration.vpnClientIpsecPolicies = vpnClientIpsecPolicies;
                } else if ("radiusServerAddress".equals(fieldName)) {
                    deserializedVpnClientConfiguration.radiusServerAddress = reader.getString();
                } else if ("radiusServerSecret".equals(fieldName)) {
                    deserializedVpnClientConfiguration.radiusServerSecret = reader.getString();
                } else if ("radiusServers".equals(fieldName)) {
                    List<RadiusServer> radiusServers = reader.readArray(reader1 -> RadiusServer.fromJson(reader1));
                    deserializedVpnClientConfiguration.radiusServers = radiusServers;
                } else if ("aadTenant".equals(fieldName)) {
                    deserializedVpnClientConfiguration.aadTenant = reader.getString();
                } else if ("aadAudience".equals(fieldName)) {
                    deserializedVpnClientConfiguration.aadAudience = reader.getString();
                } else if ("aadIssuer".equals(fieldName)) {
                    deserializedVpnClientConfiguration.aadIssuer = reader.getString();
                } else if ("vngClientConnectionConfigurations".equals(fieldName)) {
                    List<VngClientConnectionConfiguration> vngClientConnectionConfigurations
                        = reader.readArray(reader1 -> VngClientConnectionConfiguration.fromJson(reader1));
                    deserializedVpnClientConfiguration.vngClientConnectionConfigurations
                        = vngClientConnectionConfigurations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnClientConfiguration;
        });
    }
}
