// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Vpn NatRule mapping.
 */
@Fluent
public final class VpnNatRuleMapping implements JsonSerializable<VpnNatRuleMapping> {
    /*
     * Address space for Vpn NatRule mapping.
     */
    private String addressSpace;

    /*
     * Port range for Vpn NatRule mapping.
     */
    private String portRange;

    /**
     * Creates an instance of VpnNatRuleMapping class.
     */
    public VpnNatRuleMapping() {
    }

    /**
     * Get the addressSpace property: Address space for Vpn NatRule mapping.
     * 
     * @return the addressSpace value.
     */
    public String addressSpace() {
        return this.addressSpace;
    }

    /**
     * Set the addressSpace property: Address space for Vpn NatRule mapping.
     * 
     * @param addressSpace the addressSpace value to set.
     * @return the VpnNatRuleMapping object itself.
     */
    public VpnNatRuleMapping withAddressSpace(String addressSpace) {
        this.addressSpace = addressSpace;
        return this;
    }

    /**
     * Get the portRange property: Port range for Vpn NatRule mapping.
     * 
     * @return the portRange value.
     */
    public String portRange() {
        return this.portRange;
    }

    /**
     * Set the portRange property: Port range for Vpn NatRule mapping.
     * 
     * @param portRange the portRange value to set.
     * @return the VpnNatRuleMapping object itself.
     */
    public VpnNatRuleMapping withPortRange(String portRange) {
        this.portRange = portRange;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("addressSpace", this.addressSpace);
        jsonWriter.writeStringField("portRange", this.portRange);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnNatRuleMapping from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnNatRuleMapping if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnNatRuleMapping.
     */
    public static VpnNatRuleMapping fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnNatRuleMapping deserializedVpnNatRuleMapping = new VpnNatRuleMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("addressSpace".equals(fieldName)) {
                    deserializedVpnNatRuleMapping.addressSpace = reader.getString();
                } else if ("portRange".equals(fieldName)) {
                    deserializedVpnNatRuleMapping.portRange = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnNatRuleMapping;
        });
    }
}
