/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class VngClientConnectionConfigurationProperties
implements JsonSerializable<VngClientConnectionConfigurationProperties> {
    private AddressSpace vpnClientAddressPool;
    private List<SubResource> virtualNetworkGatewayPolicyGroups;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(VngClientConnectionConfigurationProperties.class);

    public AddressSpace vpnClientAddressPool() {
        return this.vpnClientAddressPool;
    }

    public VngClientConnectionConfigurationProperties withVpnClientAddressPool(AddressSpace vpnClientAddressPool) {
        this.vpnClientAddressPool = vpnClientAddressPool;
        return this;
    }

    public List<SubResource> virtualNetworkGatewayPolicyGroups() {
        return this.virtualNetworkGatewayPolicyGroups;
    }

    public VngClientConnectionConfigurationProperties withVirtualNetworkGatewayPolicyGroups(List<SubResource> virtualNetworkGatewayPolicyGroups) {
        this.virtualNetworkGatewayPolicyGroups = virtualNetworkGatewayPolicyGroups;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.vpnClientAddressPool() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vpnClientAddressPool in model VngClientConnectionConfigurationProperties"));
        }
        this.vpnClientAddressPool().validate();
        if (this.virtualNetworkGatewayPolicyGroups() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property virtualNetworkGatewayPolicyGroups in model VngClientConnectionConfigurationProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("vpnClientAddressPool", (JsonSerializable)this.vpnClientAddressPool);
        jsonWriter.writeArrayField("virtualNetworkGatewayPolicyGroups", this.virtualNetworkGatewayPolicyGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VngClientConnectionConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VngClientConnectionConfigurationProperties)jsonReader.readObject(reader -> {
            VngClientConnectionConfigurationProperties deserializedVngClientConnectionConfigurationProperties = new VngClientConnectionConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vpnClientAddressPool".equals(fieldName)) {
                    deserializedVngClientConnectionConfigurationProperties.vpnClientAddressPool = AddressSpace.fromJson(reader);
                    continue;
                }
                if ("virtualNetworkGatewayPolicyGroups".equals(fieldName)) {
                    List virtualNetworkGatewayPolicyGroups;
                    deserializedVngClientConnectionConfigurationProperties.virtualNetworkGatewayPolicyGroups = virtualNetworkGatewayPolicyGroups = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVngClientConnectionConfigurationProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVngClientConnectionConfigurationProperties;
        });
    }
}

