/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class GetVpnSitesConfigurationRequest
implements JsonSerializable<GetVpnSitesConfigurationRequest> {
    private List<String> vpnSites;
    private String outputBlobSasUrl;
    private static final ClientLogger LOGGER = new ClientLogger(GetVpnSitesConfigurationRequest.class);

    public List<String> vpnSites() {
        return this.vpnSites;
    }

    public GetVpnSitesConfigurationRequest withVpnSites(List<String> vpnSites) {
        this.vpnSites = vpnSites;
        return this;
    }

    public String outputBlobSasUrl() {
        return this.outputBlobSasUrl;
    }

    public GetVpnSitesConfigurationRequest withOutputBlobSasUrl(String outputBlobSasUrl) {
        this.outputBlobSasUrl = outputBlobSasUrl;
        return this;
    }

    public void validate() {
        if (this.outputBlobSasUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property outputBlobSasUrl in model GetVpnSitesConfigurationRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("outputBlobSasUrl", this.outputBlobSasUrl);
        jsonWriter.writeArrayField("vpnSites", this.vpnSites, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static GetVpnSitesConfigurationRequest fromJson(JsonReader jsonReader) throws IOException {
        return (GetVpnSitesConfigurationRequest)jsonReader.readObject(reader -> {
            GetVpnSitesConfigurationRequest deserializedGetVpnSitesConfigurationRequest = new GetVpnSitesConfigurationRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("outputBlobSasUrl".equals(fieldName)) {
                    deserializedGetVpnSitesConfigurationRequest.outputBlobSasUrl = reader.getString();
                    continue;
                }
                if ("vpnSites".equals(fieldName)) {
                    List vpnSites;
                    deserializedGetVpnSitesConfigurationRequest.vpnSites = vpnSites = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetVpnSitesConfigurationRequest;
        });
    }
}

