// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The operation for configuring intrusion detection. */
@Fluent
public final class FirewallPolicyIntrusionDetectionConfiguration {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(FirewallPolicyIntrusionDetectionConfiguration.class);

    /*
     * List of specific signatures states.
     */
    @JsonProperty(value = "signatureOverrides")
    private List<FirewallPolicyIntrusionDetectionSignatureSpecification> signatureOverrides;

    /*
     * List of rules for traffic to bypass.
     */
    @JsonProperty(value = "bypassTrafficSettings")
    private List<FirewallPolicyIntrusionDetectionBypassTrafficSpecifications> bypassTrafficSettings;

    /**
     * Get the signatureOverrides property: List of specific signatures states.
     *
     * @return the signatureOverrides value.
     */
    public List<FirewallPolicyIntrusionDetectionSignatureSpecification> signatureOverrides() {
        return this.signatureOverrides;
    }

    /**
     * Set the signatureOverrides property: List of specific signatures states.
     *
     * @param signatureOverrides the signatureOverrides value to set.
     * @return the FirewallPolicyIntrusionDetectionConfiguration object itself.
     */
    public FirewallPolicyIntrusionDetectionConfiguration withSignatureOverrides(
        List<FirewallPolicyIntrusionDetectionSignatureSpecification> signatureOverrides) {
        this.signatureOverrides = signatureOverrides;
        return this;
    }

    /**
     * Get the bypassTrafficSettings property: List of rules for traffic to bypass.
     *
     * @return the bypassTrafficSettings value.
     */
    public List<FirewallPolicyIntrusionDetectionBypassTrafficSpecifications> bypassTrafficSettings() {
        return this.bypassTrafficSettings;
    }

    /**
     * Set the bypassTrafficSettings property: List of rules for traffic to bypass.
     *
     * @param bypassTrafficSettings the bypassTrafficSettings value to set.
     * @return the FirewallPolicyIntrusionDetectionConfiguration object itself.
     */
    public FirewallPolicyIntrusionDetectionConfiguration withBypassTrafficSettings(
        List<FirewallPolicyIntrusionDetectionBypassTrafficSpecifications> bypassTrafficSettings) {
        this.bypassTrafficSettings = bypassTrafficSettings;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (signatureOverrides() != null) {
            signatureOverrides().forEach(e -> e.validate());
        }
        if (bypassTrafficSettings() != null) {
            bypassTrafficSettings().forEach(e -> e.validate());
        }
    }
}
