// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** PrivateDnsZoneConfig resource. */
@JsonFlatten
@Fluent
public class PrivateDnsZoneConfig {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(PrivateDnsZoneConfig.class);

    /*
     * Name of the resource that is unique within a resource group. This name
     * can be used to access the resource.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The resource id of the private dns zone.
     */
    @JsonProperty(value = "properties.privateDnsZoneId")
    private String privateDnsZoneId;

    /*
     * A collection of information regarding a recordSet, holding information
     * to identify private resources.
     */
    @JsonProperty(value = "properties.recordSets", access = JsonProperty.Access.WRITE_ONLY)
    private List<RecordSet> recordSets;

    /**
     * Get the name property: Name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     *
     * @param name the name value to set.
     * @return the PrivateDnsZoneConfig object itself.
     */
    public PrivateDnsZoneConfig withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the privateDnsZoneId property: The resource id of the private dns zone.
     *
     * @return the privateDnsZoneId value.
     */
    public String privateDnsZoneId() {
        return this.privateDnsZoneId;
    }

    /**
     * Set the privateDnsZoneId property: The resource id of the private dns zone.
     *
     * @param privateDnsZoneId the privateDnsZoneId value to set.
     * @return the PrivateDnsZoneConfig object itself.
     */
    public PrivateDnsZoneConfig withPrivateDnsZoneId(String privateDnsZoneId) {
        this.privateDnsZoneId = privateDnsZoneId;
        return this;
    }

    /**
     * Get the recordSets property: A collection of information regarding a recordSet, holding information to identify
     * private resources.
     *
     * @return the recordSets value.
     */
    public List<RecordSet> recordSets() {
        return this.recordSets;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (recordSets() != null) {
            recordSets().forEach(e -> e.validate());
        }
    }
}
