/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.BgpCommunity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class BgpServiceCommunityInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(BgpServiceCommunityInner.class);
    @JsonProperty(value="properties.serviceName")
    private String serviceName;
    @JsonProperty(value="properties.bgpCommunities")
    private List<BgpCommunity> bgpCommunities;
    @JsonProperty(value="id")
    private String id;

    public String serviceName() {
        return this.serviceName;
    }

    public BgpServiceCommunityInner withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public List<BgpCommunity> bgpCommunities() {
        return this.bgpCommunities;
    }

    public BgpServiceCommunityInner withBgpCommunities(List<BgpCommunity> bgpCommunities) {
        this.bgpCommunities = bgpCommunities;
        return this;
    }

    public String id() {
        return this.id;
    }

    public BgpServiceCommunityInner withId(String id) {
        this.id = id;
        return this;
    }

    public BgpServiceCommunityInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public BgpServiceCommunityInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.bgpCommunities() != null) {
            this.bgpCommunities().forEach(e -> e.validate());
        }
    }
}

