/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ConnectionMonitorDestination;
import com.azure.resourcemanager.network.models.ConnectionMonitorEndpoint;
import com.azure.resourcemanager.network.models.ConnectionMonitorOutput;
import com.azure.resourcemanager.network.models.ConnectionMonitorSource;
import com.azure.resourcemanager.network.models.ConnectionMonitorTestConfiguration;
import com.azure.resourcemanager.network.models.ConnectionMonitorTestGroup;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class ConnectionMonitorInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ConnectionMonitorInner.class);
    @JsonProperty(value="location")
    private String location;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="properties.source")
    private ConnectionMonitorSource source;
    @JsonProperty(value="properties.destination")
    private ConnectionMonitorDestination destination;
    @JsonProperty(value="properties.autoStart")
    private Boolean autoStart;
    @JsonProperty(value="properties.monitoringIntervalInSeconds")
    private Integer monitoringIntervalInSeconds;
    @JsonProperty(value="properties.endpoints")
    private List<ConnectionMonitorEndpoint> endpoints;
    @JsonProperty(value="properties.testConfigurations")
    private List<ConnectionMonitorTestConfiguration> testConfigurations;
    @JsonProperty(value="properties.testGroups")
    private List<ConnectionMonitorTestGroup> testGroups;
    @JsonProperty(value="properties.outputs")
    private List<ConnectionMonitorOutput> outputs;
    @JsonProperty(value="properties.notes")
    private String notes;

    public String location() {
        return this.location;
    }

    public ConnectionMonitorInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ConnectionMonitorInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ConnectionMonitorSource source() {
        return this.source;
    }

    public ConnectionMonitorInner withSource(ConnectionMonitorSource source) {
        this.source = source;
        return this;
    }

    public ConnectionMonitorDestination destination() {
        return this.destination;
    }

    public ConnectionMonitorInner withDestination(ConnectionMonitorDestination destination) {
        this.destination = destination;
        return this;
    }

    public Boolean autoStart() {
        return this.autoStart;
    }

    public ConnectionMonitorInner withAutoStart(Boolean autoStart) {
        this.autoStart = autoStart;
        return this;
    }

    public Integer monitoringIntervalInSeconds() {
        return this.monitoringIntervalInSeconds;
    }

    public ConnectionMonitorInner withMonitoringIntervalInSeconds(Integer monitoringIntervalInSeconds) {
        this.monitoringIntervalInSeconds = monitoringIntervalInSeconds;
        return this;
    }

    public List<ConnectionMonitorEndpoint> endpoints() {
        return this.endpoints;
    }

    public ConnectionMonitorInner withEndpoints(List<ConnectionMonitorEndpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public List<ConnectionMonitorTestConfiguration> testConfigurations() {
        return this.testConfigurations;
    }

    public ConnectionMonitorInner withTestConfigurations(List<ConnectionMonitorTestConfiguration> testConfigurations) {
        this.testConfigurations = testConfigurations;
        return this;
    }

    public List<ConnectionMonitorTestGroup> testGroups() {
        return this.testGroups;
    }

    public ConnectionMonitorInner withTestGroups(List<ConnectionMonitorTestGroup> testGroups) {
        this.testGroups = testGroups;
        return this;
    }

    public List<ConnectionMonitorOutput> outputs() {
        return this.outputs;
    }

    public ConnectionMonitorInner withOutputs(List<ConnectionMonitorOutput> outputs) {
        this.outputs = outputs;
        return this;
    }

    public String notes() {
        return this.notes;
    }

    public ConnectionMonitorInner withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.destination() != null) {
            this.destination().validate();
        }
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
        if (this.testConfigurations() != null) {
            this.testConfigurations().forEach(e -> e.validate());
        }
        if (this.testGroups() != null) {
            this.testGroups().forEach(e -> e.validate());
        }
        if (this.outputs() != null) {
            this.outputs().forEach(e -> e.validate());
        }
    }
}

