/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.PublicIpAddressInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class FrontendIpConfigurationInner
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(FrontendIpConfigurationInner.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="properties.inboundNatRules", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> inboundNatRules;
    @JsonProperty(value="properties.inboundNatPools", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> inboundNatPools;
    @JsonProperty(value="properties.outboundRules", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> outboundRules;
    @JsonProperty(value="properties.loadBalancingRules", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> loadBalancingRules;
    @JsonProperty(value="properties.privateIPAddress")
    private String privateIpAddress;
    @JsonProperty(value="properties.privateIPAllocationMethod")
    private IpAllocationMethod privateIpAllocationMethod;
    @JsonProperty(value="properties.privateIPAddressVersion")
    private IpVersion privateIpAddressVersion;
    @JsonProperty(value="properties.subnet")
    private SubnetInner subnet;
    @JsonProperty(value="properties.publicIPAddress")
    private PublicIpAddressInner publicIpAddress;
    @JsonProperty(value="properties.publicIPPrefix")
    private SubResource publicIpPrefix;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public String name() {
        return this.name;
    }

    public FrontendIpConfigurationInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public List<String> zones() {
        return this.zones;
    }

    public FrontendIpConfigurationInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public List<SubResource> inboundNatRules() {
        return this.inboundNatRules;
    }

    public List<SubResource> inboundNatPools() {
        return this.inboundNatPools;
    }

    public List<SubResource> outboundRules() {
        return this.outboundRules;
    }

    public List<SubResource> loadBalancingRules() {
        return this.loadBalancingRules;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public FrontendIpConfigurationInner withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    public FrontendIpConfigurationInner withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    public IpVersion privateIpAddressVersion() {
        return this.privateIpAddressVersion;
    }

    public FrontendIpConfigurationInner withPrivateIpAddressVersion(IpVersion privateIpAddressVersion) {
        this.privateIpAddressVersion = privateIpAddressVersion;
        return this;
    }

    public SubnetInner subnet() {
        return this.subnet;
    }

    public FrontendIpConfigurationInner withSubnet(SubnetInner subnet) {
        this.subnet = subnet;
        return this;
    }

    public PublicIpAddressInner publicIpAddress() {
        return this.publicIpAddress;
    }

    public FrontendIpConfigurationInner withPublicIpAddress(PublicIpAddressInner publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    public SubResource publicIpPrefix() {
        return this.publicIpPrefix;
    }

    public FrontendIpConfigurationInner withPublicIpPrefix(SubResource publicIpPrefix) {
        this.publicIpPrefix = publicIpPrefix;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public FrontendIpConfigurationInner withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.subnet() != null) {
            this.subnet().validate();
        }
        if (this.publicIpAddress() != null) {
            this.publicIpAddress().validate();
        }
    }
}

