/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionPeeringInner;
import com.azure.resourcemanager.network.implementation.ExpressRouteCrossConnectionPeeringImpl;
import com.azure.resourcemanager.network.implementation.ExpressRouteCrossConnectionPeeringsImpl;
import com.azure.resourcemanager.network.implementation.GroupableParentResourceWithTagsImpl;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitReference;
import com.azure.resourcemanager.network.models.ExpressRouteCrossConnection;
import com.azure.resourcemanager.network.models.ExpressRouteCrossConnectionPeering;
import com.azure.resourcemanager.network.models.ExpressRouteCrossConnectionPeerings;
import com.azure.resourcemanager.network.models.ServiceProviderProvisioningState;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Mono;

public class ExpressRouteCrossConnectionImpl
extends GroupableParentResourceWithTagsImpl<ExpressRouteCrossConnection, ExpressRouteCrossConnectionInner, ExpressRouteCrossConnectionImpl, NetworkManager>
implements ExpressRouteCrossConnection,
ExpressRouteCrossConnection.Update {
    private ExpressRouteCrossConnectionPeeringsImpl peerings;
    private Map<String, ExpressRouteCrossConnectionPeering> crossConnectionPeerings;

    ExpressRouteCrossConnectionImpl(String name, ExpressRouteCrossConnectionInner innerObject, NetworkManager manager) {
        super(name, innerObject, manager);
        this.initializeChildrenFromInner();
    }

    protected Mono<ExpressRouteCrossConnectionInner> createInner() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getExpressRouteCrossConnections().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ExpressRouteCrossConnectionInner)((Object)this.innerModel()));
    }

    protected void initializeChildrenFromInner() {
        this.crossConnectionPeerings = new HashMap<String, ExpressRouteCrossConnectionPeering>();
        if (((ExpressRouteCrossConnectionInner)((Object)this.innerModel())).peerings() != null) {
            for (ExpressRouteCrossConnectionPeeringInner peering : ((ExpressRouteCrossConnectionInner)((Object)this.innerModel())).peerings()) {
                this.crossConnectionPeerings.put(peering.name(), new ExpressRouteCrossConnectionPeeringImpl(this, peering, peering.peeringType()));
            }
        }
    }

    protected Mono<ExpressRouteCrossConnectionInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getExpressRouteCrossConnections().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Mono<ExpressRouteCrossConnection> refreshAsync() {
        return super.refreshAsync().map(expressRouteCrossConnection -> {
            ExpressRouteCrossConnectionImpl impl = (ExpressRouteCrossConnectionImpl)expressRouteCrossConnection;
            impl.initializeChildrenFromInner();
            return impl;
        });
    }

    @Override
    protected Mono<ExpressRouteCrossConnectionInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getExpressRouteCrossConnections().updateTagsAsync(this.resourceGroupName(), this.name(), ((ExpressRouteCrossConnectionInner)((Object)this.innerModel())).tags());
    }

    @Override
    public ExpressRouteCrossConnectionPeerings peerings() {
        if (this.peerings == null) {
            this.peerings = new ExpressRouteCrossConnectionPeeringsImpl(this);
        }
        return this.peerings;
    }

    @Override
    public String primaryAzurePort() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.innerModel())).primaryAzurePort();
    }

    @Override
    public String secondaryAzurePort() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.innerModel())).secondaryAzurePort();
    }

    @Override
    public Integer stag() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.innerModel())).stag();
    }

    @Override
    public String peeringLocation() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.innerModel())).peeringLocation();
    }

    @Override
    public int bandwidthInMbps() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((ExpressRouteCrossConnectionInner)((Object)this.innerModel())).bandwidthInMbps());
    }

    @Override
    public ExpressRouteCircuitReference expressRouteCircuit() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.innerModel())).expressRouteCircuit();
    }

    @Override
    public ServiceProviderProvisioningState serviceProviderProvisioningState() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.innerModel())).serviceProviderProvisioningState();
    }

    @Override
    public String serviceProviderNotes() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.innerModel())).serviceProviderNotes();
    }

    @Override
    public String provisioningState() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.innerModel())).provisioningState().toString();
    }

    @Override
    public Map<String, ExpressRouteCrossConnectionPeering> peeringsMap() {
        return Collections.unmodifiableMap(this.crossConnectionPeerings);
    }

    @Override
    public ExpressRouteCrossConnection.Update withServiceProviderProvisioningState(ServiceProviderProvisioningState state) {
        ((ExpressRouteCrossConnectionInner)((Object)this.innerModel())).withServiceProviderProvisioningState(state);
        return this;
    }

    @Override
    public ExpressRouteCrossConnection.Update withServiceProviderNotes(String notes) {
        ((ExpressRouteCrossConnectionInner)((Object)this.innerModel())).withServiceProviderNotes(notes);
        return this;
    }
}

