/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.LocalNetworkGatewayInner;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.AppliableWithTags;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.LocalNetworkGateway;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import reactor.core.publisher.Mono;

class LocalNetworkGatewayImpl
extends GroupableResourceImpl<LocalNetworkGateway, LocalNetworkGatewayInner, LocalNetworkGatewayImpl, NetworkManager>
implements LocalNetworkGateway,
LocalNetworkGateway.Definition,
LocalNetworkGateway.Update,
AppliableWithTags<LocalNetworkGateway> {
    LocalNetworkGatewayImpl(String name, LocalNetworkGatewayInner innerModel, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (Manager)networkManager);
    }

    @Override
    public String ipAddress() {
        return ((LocalNetworkGatewayInner)((Object)this.innerModel())).gatewayIpAddress();
    }

    @Override
    public BgpSettings bgpSettings() {
        return ((LocalNetworkGatewayInner)((Object)this.innerModel())).bgpSettings();
    }

    @Override
    public Set<String> addressSpaces() {
        HashSet<String> addressSpaces = new HashSet<String>();
        if (((LocalNetworkGatewayInner)((Object)this.innerModel())).localNetworkAddressSpace() != null && ((LocalNetworkGatewayInner)((Object)this.innerModel())).localNetworkAddressSpace().addressPrefixes() != null) {
            addressSpaces.addAll(((LocalNetworkGatewayInner)((Object)this.innerModel())).localNetworkAddressSpace().addressPrefixes());
        }
        return Collections.unmodifiableSet(addressSpaces);
    }

    @Override
    public String provisioningState() {
        return ((LocalNetworkGatewayInner)((Object)this.innerModel())).provisioningState().toString();
    }

    @Override
    public LocalNetworkGatewayImpl withIPAddress(String ipAddress) {
        ((LocalNetworkGatewayInner)((Object)this.innerModel())).withGatewayIpAddress(ipAddress);
        return this;
    }

    @Override
    public LocalNetworkGatewayImpl withAddressSpace(String cidr) {
        if (((LocalNetworkGatewayInner)((Object)this.innerModel())).localNetworkAddressSpace() == null) {
            ((LocalNetworkGatewayInner)((Object)this.innerModel())).withLocalNetworkAddressSpace(new AddressSpace());
        }
        if (((LocalNetworkGatewayInner)((Object)this.innerModel())).localNetworkAddressSpace().addressPrefixes() == null) {
            ((LocalNetworkGatewayInner)((Object)this.innerModel())).localNetworkAddressSpace().withAddressPrefixes(new ArrayList<String>());
        }
        ((LocalNetworkGatewayInner)((Object)this.innerModel())).localNetworkAddressSpace().addressPrefixes().add(cidr);
        return this;
    }

    @Override
    public LocalNetworkGatewayImpl withoutAddressSpace(String cidr) {
        if (((LocalNetworkGatewayInner)((Object)this.innerModel())).localNetworkAddressSpace() == null || ((LocalNetworkGatewayInner)((Object)this.innerModel())).localNetworkAddressSpace().addressPrefixes() == null) {
            return this;
        }
        ((LocalNetworkGatewayInner)((Object)this.innerModel())).localNetworkAddressSpace().addressPrefixes().remove(cidr);
        return this;
    }

    @Override
    public LocalNetworkGatewayImpl withBgp(long asn, String bgpPeeringAddress) {
        this.ensureBgpSettings().withAsn(asn).withBgpPeeringAddress(bgpPeeringAddress);
        return this;
    }

    @Override
    public LocalNetworkGatewayImpl withoutBgp() {
        ((LocalNetworkGatewayInner)((Object)this.innerModel())).withBgpSettings(null);
        return this;
    }

    protected Mono<LocalNetworkGatewayInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getLocalNetworkGateways().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Mono<LocalNetworkGateway> createResourceAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getLocalNetworkGateways().createOrUpdateAsync(this.resourceGroupName(), this.name(), (LocalNetworkGatewayInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    private BgpSettings ensureBgpSettings() {
        if (((LocalNetworkGatewayInner)((Object)this.innerModel())).bgpSettings() == null) {
            ((LocalNetworkGatewayInner)((Object)this.innerModel())).withBgpSettings(new BgpSettings());
        }
        return ((LocalNetworkGatewayInner)((Object)this.innerModel())).bgpSettings();
    }

    public LocalNetworkGatewayImpl updateTags() {
        return this;
    }

    @Override
    public LocalNetworkGateway applyTags() {
        return (LocalNetworkGateway)this.applyTagsAsync().block();
    }

    @Override
    public Mono<LocalNetworkGateway> applyTagsAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getLocalNetworkGateways().updateTagsAsync(this.resourceGroupName(), this.name(), ((LocalNetworkGatewayInner)((Object)this.innerModel())).tags()).flatMap(inner -> {
            this.setInner(inner);
            return Mono.just((Object)this);
        });
    }
}

