/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.VpnServerConfigurationsAssociatedWithVirtualWansClient;
import com.azure.resourcemanager.network.fluent.models.VpnServerConfigurationsResponseInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VpnServerConfigurationsAssociatedWithVirtualWansClientImpl
implements VpnServerConfigurationsAssociatedWithVirtualWansClient {
    private final ClientLogger logger = new ClientLogger(VpnServerConfigurationsAssociatedWithVirtualWansClientImpl.class);
    private final VpnServerConfigurationsAssociatedWithVirtualWansService service;
    private final NetworkManagementClientImpl client;

    VpnServerConfigurationsAssociatedWithVirtualWansClientImpl(NetworkManagementClientImpl client) {
        this.service = (VpnServerConfigurationsAssociatedWithVirtualWansService)RestProxy.create(VpnServerConfigurationsAssociatedWithVirtualWansService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> listWithResponseAsync(String resourceGroupName, String virtualWanName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualWanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualWanName is required and cannot be null."));
        }
        String apiVersion = "2020-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualWanName, "2020-11-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> listWithResponseAsync(String resourceGroupName, String virtualWanName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualWanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualWanName is required and cannot be null."));
        }
        String apiVersion = "2020-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualWanName, "2020-11-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<VpnServerConfigurationsResponseInner>, VpnServerConfigurationsResponseInner> beginListAsync(String resourceGroupName, String virtualWanName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.listWithResponseAsync(resourceGroupName, virtualWanName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VpnServerConfigurationsResponseInner.class), (Type)((Object)VpnServerConfigurationsResponseInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<VpnServerConfigurationsResponseInner>, VpnServerConfigurationsResponseInner> beginListAsync(String resourceGroupName, String virtualWanName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.listWithResponseAsync(resourceGroupName, virtualWanName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VpnServerConfigurationsResponseInner.class), (Type)((Object)VpnServerConfigurationsResponseInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<VpnServerConfigurationsResponseInner>, VpnServerConfigurationsResponseInner> beginList(String resourceGroupName, String virtualWanName) {
        return this.beginListAsync(resourceGroupName, virtualWanName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<VpnServerConfigurationsResponseInner>, VpnServerConfigurationsResponseInner> beginList(String resourceGroupName, String virtualWanName, Context context) {
        return this.beginListAsync(resourceGroupName, virtualWanName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VpnServerConfigurationsResponseInner> listAsync(String resourceGroupName, String virtualWanName) {
        return this.beginListAsync(resourceGroupName, virtualWanName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VpnServerConfigurationsResponseInner> listAsync(String resourceGroupName, String virtualWanName, Context context) {
        return this.beginListAsync(resourceGroupName, virtualWanName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VpnServerConfigurationsResponseInner list(String resourceGroupName, String virtualWanName) {
        return (VpnServerConfigurationsResponseInner)this.listAsync(resourceGroupName, virtualWanName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VpnServerConfigurationsResponseInner list(String resourceGroupName, String virtualWanName, Context context) {
        return (VpnServerConfigurationsResponseInner)this.listAsync(resourceGroupName, virtualWanName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    private static interface VpnServerConfigurationsAssociatedWithVirtualWansService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWANName}/vpnServerConfigurations")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualWANName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

