/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ApplicationGatewayClientAuthConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewaySslPolicy;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class ApplicationGatewaySslProfile
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ApplicationGatewaySslProfile.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="properties.trustedClientCertificates")
    private List<SubResource> trustedClientCertificates;
    @JsonProperty(value="properties.sslPolicy")
    private ApplicationGatewaySslPolicy sslPolicy;
    @JsonProperty(value="properties.clientAuthConfiguration")
    private ApplicationGatewayClientAuthConfiguration clientAuthConfiguration;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public String name() {
        return this.name;
    }

    public ApplicationGatewaySslProfile withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public List<SubResource> trustedClientCertificates() {
        return this.trustedClientCertificates;
    }

    public ApplicationGatewaySslProfile withTrustedClientCertificates(List<SubResource> trustedClientCertificates) {
        this.trustedClientCertificates = trustedClientCertificates;
        return this;
    }

    public ApplicationGatewaySslPolicy sslPolicy() {
        return this.sslPolicy;
    }

    public ApplicationGatewaySslProfile withSslPolicy(ApplicationGatewaySslPolicy sslPolicy) {
        this.sslPolicy = sslPolicy;
        return this;
    }

    public ApplicationGatewayClientAuthConfiguration clientAuthConfiguration() {
        return this.clientAuthConfiguration;
    }

    public ApplicationGatewaySslProfile withClientAuthConfiguration(ApplicationGatewayClientAuthConfiguration clientAuthConfiguration) {
        this.clientAuthConfiguration = clientAuthConfiguration;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ApplicationGatewaySslProfile withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.sslPolicy() != null) {
            this.sslPolicy().validate();
        }
        if (this.clientAuthConfiguration() != null) {
            this.clientAuthConfiguration().validate();
        }
    }
}

