// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Properties of path rule of an application gateway.
 */
@Fluent
public final class ApplicationGatewayPathRulePropertiesFormat
    implements JsonSerializable<ApplicationGatewayPathRulePropertiesFormat> {
    /*
     * Path rules of URL path map.
     */
    private List<String> paths;

    /*
     * Backend address pool resource of URL path map path rule.
     */
    private SubResource backendAddressPool;

    /*
     * Backend http settings resource of URL path map path rule.
     */
    private SubResource backendHttpSettings;

    /*
     * Redirect configuration resource of URL path map path rule.
     */
    private SubResource redirectConfiguration;

    /*
     * Rewrite rule set resource of URL path map path rule.
     */
    private SubResource rewriteRuleSet;

    /*
     * Load Distribution Policy resource of URL path map path rule.
     */
    private SubResource loadDistributionPolicy;

    /*
     * The provisioning state of the path rule resource.
     */
    private ProvisioningState provisioningState;

    /*
     * Reference to the FirewallPolicy resource.
     */
    private SubResource firewallPolicy;

    /**
     * Creates an instance of ApplicationGatewayPathRulePropertiesFormat class.
     */
    public ApplicationGatewayPathRulePropertiesFormat() {
    }

    /**
     * Get the paths property: Path rules of URL path map.
     * 
     * @return the paths value.
     */
    public List<String> paths() {
        return this.paths;
    }

    /**
     * Set the paths property: Path rules of URL path map.
     * 
     * @param paths the paths value to set.
     * @return the ApplicationGatewayPathRulePropertiesFormat object itself.
     */
    public ApplicationGatewayPathRulePropertiesFormat withPaths(List<String> paths) {
        this.paths = paths;
        return this;
    }

    /**
     * Get the backendAddressPool property: Backend address pool resource of URL path map path rule.
     * 
     * @return the backendAddressPool value.
     */
    public SubResource backendAddressPool() {
        return this.backendAddressPool;
    }

    /**
     * Set the backendAddressPool property: Backend address pool resource of URL path map path rule.
     * 
     * @param backendAddressPool the backendAddressPool value to set.
     * @return the ApplicationGatewayPathRulePropertiesFormat object itself.
     */
    public ApplicationGatewayPathRulePropertiesFormat withBackendAddressPool(SubResource backendAddressPool) {
        this.backendAddressPool = backendAddressPool;
        return this;
    }

    /**
     * Get the backendHttpSettings property: Backend http settings resource of URL path map path rule.
     * 
     * @return the backendHttpSettings value.
     */
    public SubResource backendHttpSettings() {
        return this.backendHttpSettings;
    }

    /**
     * Set the backendHttpSettings property: Backend http settings resource of URL path map path rule.
     * 
     * @param backendHttpSettings the backendHttpSettings value to set.
     * @return the ApplicationGatewayPathRulePropertiesFormat object itself.
     */
    public ApplicationGatewayPathRulePropertiesFormat withBackendHttpSettings(SubResource backendHttpSettings) {
        this.backendHttpSettings = backendHttpSettings;
        return this;
    }

    /**
     * Get the redirectConfiguration property: Redirect configuration resource of URL path map path rule.
     * 
     * @return the redirectConfiguration value.
     */
    public SubResource redirectConfiguration() {
        return this.redirectConfiguration;
    }

    /**
     * Set the redirectConfiguration property: Redirect configuration resource of URL path map path rule.
     * 
     * @param redirectConfiguration the redirectConfiguration value to set.
     * @return the ApplicationGatewayPathRulePropertiesFormat object itself.
     */
    public ApplicationGatewayPathRulePropertiesFormat withRedirectConfiguration(SubResource redirectConfiguration) {
        this.redirectConfiguration = redirectConfiguration;
        return this;
    }

    /**
     * Get the rewriteRuleSet property: Rewrite rule set resource of URL path map path rule.
     * 
     * @return the rewriteRuleSet value.
     */
    public SubResource rewriteRuleSet() {
        return this.rewriteRuleSet;
    }

    /**
     * Set the rewriteRuleSet property: Rewrite rule set resource of URL path map path rule.
     * 
     * @param rewriteRuleSet the rewriteRuleSet value to set.
     * @return the ApplicationGatewayPathRulePropertiesFormat object itself.
     */
    public ApplicationGatewayPathRulePropertiesFormat withRewriteRuleSet(SubResource rewriteRuleSet) {
        this.rewriteRuleSet = rewriteRuleSet;
        return this;
    }

    /**
     * Get the loadDistributionPolicy property: Load Distribution Policy resource of URL path map path rule.
     * 
     * @return the loadDistributionPolicy value.
     */
    public SubResource loadDistributionPolicy() {
        return this.loadDistributionPolicy;
    }

    /**
     * Set the loadDistributionPolicy property: Load Distribution Policy resource of URL path map path rule.
     * 
     * @param loadDistributionPolicy the loadDistributionPolicy value to set.
     * @return the ApplicationGatewayPathRulePropertiesFormat object itself.
     */
    public ApplicationGatewayPathRulePropertiesFormat withLoadDistributionPolicy(SubResource loadDistributionPolicy) {
        this.loadDistributionPolicy = loadDistributionPolicy;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the path rule resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the firewallPolicy property: Reference to the FirewallPolicy resource.
     * 
     * @return the firewallPolicy value.
     */
    public SubResource firewallPolicy() {
        return this.firewallPolicy;
    }

    /**
     * Set the firewallPolicy property: Reference to the FirewallPolicy resource.
     * 
     * @param firewallPolicy the firewallPolicy value to set.
     * @return the ApplicationGatewayPathRulePropertiesFormat object itself.
     */
    public ApplicationGatewayPathRulePropertiesFormat withFirewallPolicy(SubResource firewallPolicy) {
        this.firewallPolicy = firewallPolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("paths", this.paths, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("backendAddressPool", this.backendAddressPool);
        jsonWriter.writeJsonField("backendHttpSettings", this.backendHttpSettings);
        jsonWriter.writeJsonField("redirectConfiguration", this.redirectConfiguration);
        jsonWriter.writeJsonField("rewriteRuleSet", this.rewriteRuleSet);
        jsonWriter.writeJsonField("loadDistributionPolicy", this.loadDistributionPolicy);
        jsonWriter.writeJsonField("firewallPolicy", this.firewallPolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayPathRulePropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayPathRulePropertiesFormat if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayPathRulePropertiesFormat.
     */
    public static ApplicationGatewayPathRulePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayPathRulePropertiesFormat deserializedApplicationGatewayPathRulePropertiesFormat
                = new ApplicationGatewayPathRulePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("paths".equals(fieldName)) {
                    List<String> paths = reader.readArray(reader1 -> reader1.getString());
                    deserializedApplicationGatewayPathRulePropertiesFormat.paths = paths;
                } else if ("backendAddressPool".equals(fieldName)) {
                    deserializedApplicationGatewayPathRulePropertiesFormat.backendAddressPool
                        = SubResource.fromJson(reader);
                } else if ("backendHttpSettings".equals(fieldName)) {
                    deserializedApplicationGatewayPathRulePropertiesFormat.backendHttpSettings
                        = SubResource.fromJson(reader);
                } else if ("redirectConfiguration".equals(fieldName)) {
                    deserializedApplicationGatewayPathRulePropertiesFormat.redirectConfiguration
                        = SubResource.fromJson(reader);
                } else if ("rewriteRuleSet".equals(fieldName)) {
                    deserializedApplicationGatewayPathRulePropertiesFormat.rewriteRuleSet
                        = SubResource.fromJson(reader);
                } else if ("loadDistributionPolicy".equals(fieldName)) {
                    deserializedApplicationGatewayPathRulePropertiesFormat.loadDistributionPolicy
                        = SubResource.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayPathRulePropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("firewallPolicy".equals(fieldName)) {
                    deserializedApplicationGatewayPathRulePropertiesFormat.firewallPolicy
                        = SubResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayPathRulePropertiesFormat;
        });
    }
}
