// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Azure Firewall FQDN Tag Properties.
 */
@Immutable
public final class AzureFirewallFqdnTagPropertiesFormat
    implements JsonSerializable<AzureFirewallFqdnTagPropertiesFormat> {
    /*
     * The provisioning state of the Azure firewall FQDN tag resource.
     */
    private ProvisioningState provisioningState;

    /*
     * The name of this FQDN Tag.
     */
    private String fqdnTagName;

    /**
     * Creates an instance of AzureFirewallFqdnTagPropertiesFormat class.
     */
    public AzureFirewallFqdnTagPropertiesFormat() {
    }

    /**
     * Get the provisioningState property: The provisioning state of the Azure firewall FQDN tag resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the fqdnTagName property: The name of this FQDN Tag.
     * 
     * @return the fqdnTagName value.
     */
    public String fqdnTagName() {
        return this.fqdnTagName;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFirewallFqdnTagPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFirewallFqdnTagPropertiesFormat if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureFirewallFqdnTagPropertiesFormat.
     */
    public static AzureFirewallFqdnTagPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFirewallFqdnTagPropertiesFormat deserializedAzureFirewallFqdnTagPropertiesFormat
                = new AzureFirewallFqdnTagPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedAzureFirewallFqdnTagPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("fqdnTagName".equals(fieldName)) {
                    deserializedAzureFirewallFqdnTagPropertiesFormat.fqdnTagName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureFirewallFqdnTagPropertiesFormat;
        });
    }
}
