// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConnectionStatus;
import com.azure.resourcemanager.network.models.ConnectivityHop;
import java.io.IOException;
import java.util.List;

/**
 * Information on the connectivity status.
 */
@Immutable
public final class ConnectivityInformationInner implements JsonSerializable<ConnectivityInformationInner> {
    /*
     * List of hops between the source and the destination.
     */
    private List<ConnectivityHop> hops;

    /*
     * The connection status.
     */
    private ConnectionStatus connectionStatus;

    /*
     * Average latency in milliseconds.
     */
    private Integer avgLatencyInMs;

    /*
     * Minimum latency in milliseconds.
     */
    private Integer minLatencyInMs;

    /*
     * Maximum latency in milliseconds.
     */
    private Integer maxLatencyInMs;

    /*
     * Total number of probes sent.
     */
    private Integer probesSent;

    /*
     * Number of failed probes.
     */
    private Integer probesFailed;

    /**
     * Creates an instance of ConnectivityInformationInner class.
     */
    public ConnectivityInformationInner() {
    }

    /**
     * Get the hops property: List of hops between the source and the destination.
     * 
     * @return the hops value.
     */
    public List<ConnectivityHop> hops() {
        return this.hops;
    }

    /**
     * Get the connectionStatus property: The connection status.
     * 
     * @return the connectionStatus value.
     */
    public ConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    /**
     * Get the avgLatencyInMs property: Average latency in milliseconds.
     * 
     * @return the avgLatencyInMs value.
     */
    public Integer avgLatencyInMs() {
        return this.avgLatencyInMs;
    }

    /**
     * Get the minLatencyInMs property: Minimum latency in milliseconds.
     * 
     * @return the minLatencyInMs value.
     */
    public Integer minLatencyInMs() {
        return this.minLatencyInMs;
    }

    /**
     * Get the maxLatencyInMs property: Maximum latency in milliseconds.
     * 
     * @return the maxLatencyInMs value.
     */
    public Integer maxLatencyInMs() {
        return this.maxLatencyInMs;
    }

    /**
     * Get the probesSent property: Total number of probes sent.
     * 
     * @return the probesSent value.
     */
    public Integer probesSent() {
        return this.probesSent;
    }

    /**
     * Get the probesFailed property: Number of failed probes.
     * 
     * @return the probesFailed value.
     */
    public Integer probesFailed() {
        return this.probesFailed;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (hops() != null) {
            hops().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectivityInformationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectivityInformationInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectivityInformationInner.
     */
    public static ConnectivityInformationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectivityInformationInner deserializedConnectivityInformationInner = new ConnectivityInformationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("hops".equals(fieldName)) {
                    List<ConnectivityHop> hops = reader.readArray(reader1 -> ConnectivityHop.fromJson(reader1));
                    deserializedConnectivityInformationInner.hops = hops;
                } else if ("connectionStatus".equals(fieldName)) {
                    deserializedConnectivityInformationInner.connectionStatus
                        = ConnectionStatus.fromString(reader.getString());
                } else if ("avgLatencyInMs".equals(fieldName)) {
                    deserializedConnectivityInformationInner.avgLatencyInMs = reader.getNullable(JsonReader::getInt);
                } else if ("minLatencyInMs".equals(fieldName)) {
                    deserializedConnectivityInformationInner.minLatencyInMs = reader.getNullable(JsonReader::getInt);
                } else if ("maxLatencyInMs".equals(fieldName)) {
                    deserializedConnectivityInformationInner.maxLatencyInMs = reader.getNullable(JsonReader::getInt);
                } else if ("probesSent".equals(fieldName)) {
                    deserializedConnectivityInformationInner.probesSent = reader.getNullable(JsonReader::getInt);
                } else if ("probesFailed".equals(fieldName)) {
                    deserializedConnectivityInformationInner.probesFailed = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectivityInformationInner;
        });
    }
}
