// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.FlowLogFormatParameters;
import com.azure.resourcemanager.network.models.ManagedServiceIdentity;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RetentionPolicyParameters;
import com.azure.resourcemanager.network.models.TrafficAnalyticsProperties;
import java.io.IOException;
import java.util.Map;

/**
 * A flow log resource.
 */
@Fluent
public final class FlowLogInner extends Resource {
    /*
     * Properties of the flow log.
     */
    private FlowLogPropertiesFormat innerProperties;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * FlowLog resource Managed Identity
     */
    private ManagedServiceIdentity identity;

    /*
     * Resource ID.
     */
    private String id;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /**
     * Creates an instance of FlowLogInner class.
     */
    public FlowLogInner() {
    }

    /**
     * Get the innerProperties property: Properties of the flow log.
     * 
     * @return the innerProperties value.
     */
    private FlowLogPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the identity property: FlowLog resource Managed Identity.
     * 
     * @return the identity value.
     */
    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: FlowLog resource Managed Identity.
     * 
     * @param identity the identity value to set.
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     * 
     * @param id the id value to set.
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public FlowLogInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public FlowLogInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the targetResourceId property: ID of network security group to which flow log will be applied.
     * 
     * @return the targetResourceId value.
     */
    public String targetResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceId();
    }

    /**
     * Set the targetResourceId property: ID of network security group to which flow log will be applied.
     * 
     * @param targetResourceId the targetResourceId value to set.
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withTargetResourceId(String targetResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogPropertiesFormat();
        }
        this.innerProperties().withTargetResourceId(targetResourceId);
        return this;
    }

    /**
     * Get the targetResourceGuid property: Guid of network security group to which flow log will be applied.
     * 
     * @return the targetResourceGuid value.
     */
    public String targetResourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceGuid();
    }

    /**
     * Get the storageId property: ID of the storage account which is used to store the flow log.
     * 
     * @return the storageId value.
     */
    public String storageId() {
        return this.innerProperties() == null ? null : this.innerProperties().storageId();
    }

    /**
     * Set the storageId property: ID of the storage account which is used to store the flow log.
     * 
     * @param storageId the storageId value to set.
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withStorageId(String storageId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogPropertiesFormat();
        }
        this.innerProperties().withStorageId(storageId);
        return this;
    }

    /**
     * Get the enabledFilteringCriteria property: Optional field to filter network traffic logs based on SrcIP, SrcPort,
     * DstIP, DstPort, Protocol, Encryption, Direction and Action. If not specified, all network traffic will be logged.
     * 
     * @return the enabledFilteringCriteria value.
     */
    public String enabledFilteringCriteria() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledFilteringCriteria();
    }

    /**
     * Set the enabledFilteringCriteria property: Optional field to filter network traffic logs based on SrcIP, SrcPort,
     * DstIP, DstPort, Protocol, Encryption, Direction and Action. If not specified, all network traffic will be logged.
     * 
     * @param enabledFilteringCriteria the enabledFilteringCriteria value to set.
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withEnabledFilteringCriteria(String enabledFilteringCriteria) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogPropertiesFormat();
        }
        this.innerProperties().withEnabledFilteringCriteria(enabledFilteringCriteria);
        return this;
    }

    /**
     * Get the enabled property: Flag to enable/disable flow logging.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    /**
     * Set the enabled property: Flag to enable/disable flow logging.
     * 
     * @param enabled the enabled value to set.
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogPropertiesFormat();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    /**
     * Get the retentionPolicy property: Parameters that define the retention policy for flow log.
     * 
     * @return the retentionPolicy value.
     */
    public RetentionPolicyParameters retentionPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionPolicy();
    }

    /**
     * Set the retentionPolicy property: Parameters that define the retention policy for flow log.
     * 
     * @param retentionPolicy the retentionPolicy value to set.
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withRetentionPolicy(RetentionPolicyParameters retentionPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogPropertiesFormat();
        }
        this.innerProperties().withRetentionPolicy(retentionPolicy);
        return this;
    }

    /**
     * Get the format property: Parameters that define the flow log format.
     * 
     * @return the format value.
     */
    public FlowLogFormatParameters format() {
        return this.innerProperties() == null ? null : this.innerProperties().format();
    }

    /**
     * Set the format property: Parameters that define the flow log format.
     * 
     * @param format the format value to set.
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withFormat(FlowLogFormatParameters format) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogPropertiesFormat();
        }
        this.innerProperties().withFormat(format);
        return this;
    }

    /**
     * Get the flowAnalyticsConfiguration property: Parameters that define the configuration of traffic analytics.
     * 
     * @return the flowAnalyticsConfiguration value.
     */
    public TrafficAnalyticsProperties flowAnalyticsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().flowAnalyticsConfiguration();
    }

    /**
     * Set the flowAnalyticsConfiguration property: Parameters that define the configuration of traffic analytics.
     * 
     * @param flowAnalyticsConfiguration the flowAnalyticsConfiguration value to set.
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withFlowAnalyticsConfiguration(TrafficAnalyticsProperties flowAnalyticsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FlowLogPropertiesFormat();
        }
        this.innerProperties().withFlowAnalyticsConfiguration(flowAnalyticsConfiguration);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the flow log.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FlowLogInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FlowLogInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FlowLogInner.
     */
    public static FlowLogInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FlowLogInner deserializedFlowLogInner = new FlowLogInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedFlowLogInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedFlowLogInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedFlowLogInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedFlowLogInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedFlowLogInner.innerProperties = FlowLogPropertiesFormat.fromJson(reader);
                } else if ("etag".equals(fieldName)) {
                    deserializedFlowLogInner.etag = reader.getString();
                } else if ("identity".equals(fieldName)) {
                    deserializedFlowLogInner.identity = ManagedServiceIdentity.fromJson(reader);
                } else if ("id".equals(fieldName)) {
                    deserializedFlowLogInner.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFlowLogInner;
        });
    }
}
