// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ExpressRouteFailoverConnectionResourceDetails model.
 */
@Fluent
public final class ExpressRouteFailoverConnectionResourceDetails
    implements JsonSerializable<ExpressRouteFailoverConnectionResourceDetails> {
    /*
     * NRP Resource URI of the connection
     */
    private String nrpResourceUri;

    /*
     * Connection Name
     */
    private String name;

    /*
     * The current status of the connection
     */
    private FailoverConnectionStatus status;

    /*
     * Time when the connection was last updated
     */
    private String lastUpdatedTime;

    /**
     * Creates an instance of ExpressRouteFailoverConnectionResourceDetails class.
     */
    public ExpressRouteFailoverConnectionResourceDetails() {
    }

    /**
     * Get the nrpResourceUri property: NRP Resource URI of the connection.
     * 
     * @return the nrpResourceUri value.
     */
    public String nrpResourceUri() {
        return this.nrpResourceUri;
    }

    /**
     * Set the nrpResourceUri property: NRP Resource URI of the connection.
     * 
     * @param nrpResourceUri the nrpResourceUri value to set.
     * @return the ExpressRouteFailoverConnectionResourceDetails object itself.
     */
    public ExpressRouteFailoverConnectionResourceDetails withNrpResourceUri(String nrpResourceUri) {
        this.nrpResourceUri = nrpResourceUri;
        return this;
    }

    /**
     * Get the name property: Connection Name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Connection Name.
     * 
     * @param name the name value to set.
     * @return the ExpressRouteFailoverConnectionResourceDetails object itself.
     */
    public ExpressRouteFailoverConnectionResourceDetails withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the status property: The current status of the connection.
     * 
     * @return the status value.
     */
    public FailoverConnectionStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The current status of the connection.
     * 
     * @param status the status value to set.
     * @return the ExpressRouteFailoverConnectionResourceDetails object itself.
     */
    public ExpressRouteFailoverConnectionResourceDetails withStatus(FailoverConnectionStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the lastUpdatedTime property: Time when the connection was last updated.
     * 
     * @return the lastUpdatedTime value.
     */
    public String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    /**
     * Set the lastUpdatedTime property: Time when the connection was last updated.
     * 
     * @param lastUpdatedTime the lastUpdatedTime value to set.
     * @return the ExpressRouteFailoverConnectionResourceDetails object itself.
     */
    public ExpressRouteFailoverConnectionResourceDetails withLastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nrpResourceUri", this.nrpResourceUri);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("lastUpdatedTime", this.lastUpdatedTime);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteFailoverConnectionResourceDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteFailoverConnectionResourceDetails if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteFailoverConnectionResourceDetails.
     */
    public static ExpressRouteFailoverConnectionResourceDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteFailoverConnectionResourceDetails deserializedExpressRouteFailoverConnectionResourceDetails
                = new ExpressRouteFailoverConnectionResourceDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nrpResourceUri".equals(fieldName)) {
                    deserializedExpressRouteFailoverConnectionResourceDetails.nrpResourceUri = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedExpressRouteFailoverConnectionResourceDetails.name = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedExpressRouteFailoverConnectionResourceDetails.status
                        = FailoverConnectionStatus.fromString(reader.getString());
                } else if ("lastUpdatedTime".equals(fieldName)) {
                    deserializedExpressRouteFailoverConnectionResourceDetails.lastUpdatedTime = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteFailoverConnectionResourceDetails;
        });
    }
}
