// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Define user session identifier group by clauses.
 */
@Fluent
public final class GroupByUserSession implements JsonSerializable<GroupByUserSession> {
    /*
     * List of group by clause variables.
     */
    private List<GroupByVariable> groupByVariables;

    /**
     * Creates an instance of GroupByUserSession class.
     */
    public GroupByUserSession() {
    }

    /**
     * Get the groupByVariables property: List of group by clause variables.
     * 
     * @return the groupByVariables value.
     */
    public List<GroupByVariable> groupByVariables() {
        return this.groupByVariables;
    }

    /**
     * Set the groupByVariables property: List of group by clause variables.
     * 
     * @param groupByVariables the groupByVariables value to set.
     * @return the GroupByUserSession object itself.
     */
    public GroupByUserSession withGroupByVariables(List<GroupByVariable> groupByVariables) {
        this.groupByVariables = groupByVariables;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (groupByVariables() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property groupByVariables in model GroupByUserSession"));
        } else {
            groupByVariables().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GroupByUserSession.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("groupByVariables", this.groupByVariables,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GroupByUserSession from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GroupByUserSession if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GroupByUserSession.
     */
    public static GroupByUserSession fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GroupByUserSession deserializedGroupByUserSession = new GroupByUserSession();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("groupByVariables".equals(fieldName)) {
                    List<GroupByVariable> groupByVariables
                        = reader.readArray(reader1 -> GroupByVariable.fromJson(reader1));
                    deserializedGroupByUserSession.groupByVariables = groupByVariables;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGroupByUserSession;
        });
    }
}
