// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.SecurityUserConfigurationInner;
import java.io.IOException;
import java.util.List;

/**
 * A list of network manager security user configurations.
 */
@Fluent
public final class SecurityUserConfigurationListResult
    implements JsonSerializable<SecurityUserConfigurationListResult> {
    /*
     * Gets a page of security user configurations
     */
    private List<SecurityUserConfigurationInner> value;

    /*
     * Gets the URL to get the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of SecurityUserConfigurationListResult class.
     */
    public SecurityUserConfigurationListResult() {
    }

    /**
     * Get the value property: Gets a page of security user configurations.
     * 
     * @return the value value.
     */
    public List<SecurityUserConfigurationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Gets a page of security user configurations.
     * 
     * @param value the value value to set.
     * @return the SecurityUserConfigurationListResult object itself.
     */
    public SecurityUserConfigurationListResult withValue(List<SecurityUserConfigurationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Gets the URL to get the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Gets the URL to get the next page of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the SecurityUserConfigurationListResult object itself.
     */
    public SecurityUserConfigurationListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityUserConfigurationListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityUserConfigurationListResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecurityUserConfigurationListResult.
     */
    public static SecurityUserConfigurationListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityUserConfigurationListResult deserializedSecurityUserConfigurationListResult
                = new SecurityUserConfigurationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SecurityUserConfigurationInner> value
                        = reader.readArray(reader1 -> SecurityUserConfigurationInner.fromJson(reader1));
                    deserializedSecurityUserConfigurationListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSecurityUserConfigurationListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityUserConfigurationListResult;
        });
    }
}
