/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AvailableProvidersListCountry;
import java.io.IOException;
import java.util.List;

public final class AvailableProvidersListInner
implements JsonSerializable<AvailableProvidersListInner> {
    private List<AvailableProvidersListCountry> countries;
    private static final ClientLogger LOGGER = new ClientLogger(AvailableProvidersListInner.class);

    public List<AvailableProvidersListCountry> countries() {
        return this.countries;
    }

    public AvailableProvidersListInner withCountries(List<AvailableProvidersListCountry> countries) {
        this.countries = countries;
        return this;
    }

    public void validate() {
        if (this.countries() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property countries in model AvailableProvidersListInner"));
        }
        this.countries().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("countries", this.countries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AvailableProvidersListInner fromJson(JsonReader jsonReader) throws IOException {
        return (AvailableProvidersListInner)jsonReader.readObject(reader -> {
            AvailableProvidersListInner deserializedAvailableProvidersListInner = new AvailableProvidersListInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("countries".equals(fieldName)) {
                    List countries;
                    deserializedAvailableProvidersListInner.countries = countries = reader.readArray(reader1 -> AvailableProvidersListCountry.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvailableProvidersListInner;
        });
    }
}

