/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.FirewallPolicyIntrusionDetectionBypassTrafficSpecifications;
import com.azure.resourcemanager.network.models.FirewallPolicyIntrusionDetectionSignatureSpecification;
import java.io.IOException;
import java.util.List;

public final class FirewallPolicyIntrusionDetectionConfiguration
implements JsonSerializable<FirewallPolicyIntrusionDetectionConfiguration> {
    private List<FirewallPolicyIntrusionDetectionSignatureSpecification> signatureOverrides;
    private List<FirewallPolicyIntrusionDetectionBypassTrafficSpecifications> bypassTrafficSettings;
    private List<String> privateRanges;

    public List<FirewallPolicyIntrusionDetectionSignatureSpecification> signatureOverrides() {
        return this.signatureOverrides;
    }

    public FirewallPolicyIntrusionDetectionConfiguration withSignatureOverrides(List<FirewallPolicyIntrusionDetectionSignatureSpecification> signatureOverrides) {
        this.signatureOverrides = signatureOverrides;
        return this;
    }

    public List<FirewallPolicyIntrusionDetectionBypassTrafficSpecifications> bypassTrafficSettings() {
        return this.bypassTrafficSettings;
    }

    public FirewallPolicyIntrusionDetectionConfiguration withBypassTrafficSettings(List<FirewallPolicyIntrusionDetectionBypassTrafficSpecifications> bypassTrafficSettings) {
        this.bypassTrafficSettings = bypassTrafficSettings;
        return this;
    }

    public List<String> privateRanges() {
        return this.privateRanges;
    }

    public FirewallPolicyIntrusionDetectionConfiguration withPrivateRanges(List<String> privateRanges) {
        this.privateRanges = privateRanges;
        return this;
    }

    public void validate() {
        if (this.signatureOverrides() != null) {
            this.signatureOverrides().forEach(e -> e.validate());
        }
        if (this.bypassTrafficSettings() != null) {
            this.bypassTrafficSettings().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("signatureOverrides", this.signatureOverrides, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("bypassTrafficSettings", this.bypassTrafficSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("privateRanges", this.privateRanges, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static FirewallPolicyIntrusionDetectionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (FirewallPolicyIntrusionDetectionConfiguration)jsonReader.readObject(reader -> {
            FirewallPolicyIntrusionDetectionConfiguration deserializedFirewallPolicyIntrusionDetectionConfiguration = new FirewallPolicyIntrusionDetectionConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("signatureOverrides".equals(fieldName)) {
                    List signatureOverrides;
                    deserializedFirewallPolicyIntrusionDetectionConfiguration.signatureOverrides = signatureOverrides = reader.readArray(reader1 -> FirewallPolicyIntrusionDetectionSignatureSpecification.fromJson(reader1));
                    continue;
                }
                if ("bypassTrafficSettings".equals(fieldName)) {
                    List bypassTrafficSettings;
                    deserializedFirewallPolicyIntrusionDetectionConfiguration.bypassTrafficSettings = bypassTrafficSettings = reader.readArray(reader1 -> FirewallPolicyIntrusionDetectionBypassTrafficSpecifications.fromJson(reader1));
                    continue;
                }
                if ("privateRanges".equals(fieldName)) {
                    List privateRanges;
                    deserializedFirewallPolicyIntrusionDetectionConfiguration.privateRanges = privateRanges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFirewallPolicyIntrusionDetectionConfiguration;
        });
    }
}

