/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeeringConfig;
import com.azure.resourcemanager.network.models.ExpressRoutePeeringState;
import com.azure.resourcemanager.network.models.ExpressRoutePeeringType;
import com.azure.resourcemanager.network.models.Ipv6ExpressRouteCircuitPeeringConfig;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ExpressRouteCrossConnectionPeeringProperties
implements JsonSerializable<ExpressRouteCrossConnectionPeeringProperties> {
    private ExpressRoutePeeringType peeringType;
    private ExpressRoutePeeringState state;
    private Integer azureAsn;
    private Long peerAsn;
    private String primaryPeerAddressPrefix;
    private String secondaryPeerAddressPrefix;
    private String primaryAzurePort;
    private String secondaryAzurePort;
    private String sharedKey;
    private Integer vlanId;
    private ExpressRouteCircuitPeeringConfig microsoftPeeringConfig;
    private ProvisioningState provisioningState;
    private String gatewayManagerEtag;
    private String lastModifiedBy;
    private Ipv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig;

    public ExpressRoutePeeringType peeringType() {
        return this.peeringType;
    }

    public ExpressRouteCrossConnectionPeeringProperties withPeeringType(ExpressRoutePeeringType peeringType) {
        this.peeringType = peeringType;
        return this;
    }

    public ExpressRoutePeeringState state() {
        return this.state;
    }

    public ExpressRouteCrossConnectionPeeringProperties withState(ExpressRoutePeeringState state) {
        this.state = state;
        return this;
    }

    public Integer azureAsn() {
        return this.azureAsn;
    }

    public Long peerAsn() {
        return this.peerAsn;
    }

    public ExpressRouteCrossConnectionPeeringProperties withPeerAsn(Long peerAsn) {
        this.peerAsn = peerAsn;
        return this;
    }

    public String primaryPeerAddressPrefix() {
        return this.primaryPeerAddressPrefix;
    }

    public ExpressRouteCrossConnectionPeeringProperties withPrimaryPeerAddressPrefix(String primaryPeerAddressPrefix) {
        this.primaryPeerAddressPrefix = primaryPeerAddressPrefix;
        return this;
    }

    public String secondaryPeerAddressPrefix() {
        return this.secondaryPeerAddressPrefix;
    }

    public ExpressRouteCrossConnectionPeeringProperties withSecondaryPeerAddressPrefix(String secondaryPeerAddressPrefix) {
        this.secondaryPeerAddressPrefix = secondaryPeerAddressPrefix;
        return this;
    }

    public String primaryAzurePort() {
        return this.primaryAzurePort;
    }

    public String secondaryAzurePort() {
        return this.secondaryAzurePort;
    }

    public String sharedKey() {
        return this.sharedKey;
    }

    public ExpressRouteCrossConnectionPeeringProperties withSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
        return this;
    }

    public Integer vlanId() {
        return this.vlanId;
    }

    public ExpressRouteCrossConnectionPeeringProperties withVlanId(Integer vlanId) {
        this.vlanId = vlanId;
        return this;
    }

    public ExpressRouteCircuitPeeringConfig microsoftPeeringConfig() {
        return this.microsoftPeeringConfig;
    }

    public ExpressRouteCrossConnectionPeeringProperties withMicrosoftPeeringConfig(ExpressRouteCircuitPeeringConfig microsoftPeeringConfig) {
        this.microsoftPeeringConfig = microsoftPeeringConfig;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String gatewayManagerEtag() {
        return this.gatewayManagerEtag;
    }

    public ExpressRouteCrossConnectionPeeringProperties withGatewayManagerEtag(String gatewayManagerEtag) {
        this.gatewayManagerEtag = gatewayManagerEtag;
        return this;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public Ipv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig() {
        return this.ipv6PeeringConfig;
    }

    public ExpressRouteCrossConnectionPeeringProperties withIpv6PeeringConfig(Ipv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig) {
        this.ipv6PeeringConfig = ipv6PeeringConfig;
        return this;
    }

    public void validate() {
        if (this.microsoftPeeringConfig() != null) {
            this.microsoftPeeringConfig().validate();
        }
        if (this.ipv6PeeringConfig() != null) {
            this.ipv6PeeringConfig().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("peeringType", this.peeringType == null ? null : this.peeringType.toString());
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeNumberField("peerASN", (Number)this.peerAsn);
        jsonWriter.writeStringField("primaryPeerAddressPrefix", this.primaryPeerAddressPrefix);
        jsonWriter.writeStringField("secondaryPeerAddressPrefix", this.secondaryPeerAddressPrefix);
        jsonWriter.writeStringField("sharedKey", this.sharedKey);
        jsonWriter.writeNumberField("vlanId", (Number)this.vlanId);
        jsonWriter.writeJsonField("microsoftPeeringConfig", (JsonSerializable)this.microsoftPeeringConfig);
        jsonWriter.writeStringField("gatewayManagerEtag", this.gatewayManagerEtag);
        jsonWriter.writeJsonField("ipv6PeeringConfig", (JsonSerializable)this.ipv6PeeringConfig);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteCrossConnectionPeeringProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteCrossConnectionPeeringProperties)jsonReader.readObject(reader -> {
            ExpressRouteCrossConnectionPeeringProperties deserializedExpressRouteCrossConnectionPeeringProperties = new ExpressRouteCrossConnectionPeeringProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("peeringType".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringProperties.peeringType = ExpressRoutePeeringType.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringProperties.state = ExpressRoutePeeringState.fromString(reader.getString());
                    continue;
                }
                if ("azureASN".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringProperties.azureAsn = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("peerASN".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringProperties.peerAsn = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("primaryPeerAddressPrefix".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringProperties.primaryPeerAddressPrefix = reader.getString();
                    continue;
                }
                if ("secondaryPeerAddressPrefix".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringProperties.secondaryPeerAddressPrefix = reader.getString();
                    continue;
                }
                if ("primaryAzurePort".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringProperties.primaryAzurePort = reader.getString();
                    continue;
                }
                if ("secondaryAzurePort".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringProperties.secondaryAzurePort = reader.getString();
                    continue;
                }
                if ("sharedKey".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringProperties.sharedKey = reader.getString();
                    continue;
                }
                if ("vlanId".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringProperties.vlanId = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("microsoftPeeringConfig".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringProperties.microsoftPeeringConfig = ExpressRouteCircuitPeeringConfig.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("gatewayManagerEtag".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringProperties.gatewayManagerEtag = reader.getString();
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringProperties.lastModifiedBy = reader.getString();
                    continue;
                }
                if ("ipv6PeeringConfig".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringProperties.ipv6PeeringConfig = Ipv6ExpressRouteCircuitPeeringConfig.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteCrossConnectionPeeringProperties;
        });
    }
}

