/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class IpGroupPropertiesFormat
implements JsonSerializable<IpGroupPropertiesFormat> {
    private ProvisioningState provisioningState;
    private List<String> ipAddresses;
    private List<SubResource> firewalls;
    private List<SubResource> firewallPolicies;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<String> ipAddresses() {
        return this.ipAddresses;
    }

    public IpGroupPropertiesFormat withIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
        return this;
    }

    public List<SubResource> firewalls() {
        return this.firewalls;
    }

    public List<SubResource> firewallPolicies() {
        return this.firewallPolicies;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ipAddresses", this.ipAddresses, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static IpGroupPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (IpGroupPropertiesFormat)jsonReader.readObject(reader -> {
            IpGroupPropertiesFormat deserializedIpGroupPropertiesFormat = new IpGroupPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedIpGroupPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("ipAddresses".equals(fieldName)) {
                    List ipAddresses;
                    deserializedIpGroupPropertiesFormat.ipAddresses = ipAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("firewalls".equals(fieldName)) {
                    List firewalls;
                    deserializedIpGroupPropertiesFormat.firewalls = firewalls = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("firewallPolicies".equals(fieldName)) {
                    List firewallPolicies;
                    deserializedIpGroupPropertiesFormat.firewallPolicies = firewallPolicies = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpGroupPropertiesFormat;
        });
    }
}

