/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NspProfileProperties;
import com.azure.resourcemanager.network.models.SecurityPerimeterProxyResource;
import com.azure.resourcemanager.network.models.SecurityPerimeterSystemData;
import java.io.IOException;

public final class NspProfileInner
extends SecurityPerimeterProxyResource {
    private NspProfileProperties innerProperties;
    private SecurityPerimeterSystemData systemData;
    private String type;
    private String name;
    private String id;

    private NspProfileProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public SecurityPerimeterSystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String accessRulesVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().accessRulesVersion();
    }

    public String diagnosticSettingsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().diagnosticSettingsVersion();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NspProfileInner fromJson(JsonReader jsonReader) throws IOException {
        return (NspProfileInner)((Object)jsonReader.readObject(reader -> {
            NspProfileInner deserializedNspProfileInner = new NspProfileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNspProfileInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNspProfileInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNspProfileInner.type = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedNspProfileInner.systemData = SecurityPerimeterSystemData.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNspProfileInner.innerProperties = NspProfileProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNspProfileInner;
        }));
    }
}

