/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.RouteSourceDetails;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class GatewayRouteSet
implements JsonSerializable<GatewayRouteSet> {
    private String name;
    private List<String> locations;
    private Map<String, List<RouteSourceDetails>> details;

    public String name() {
        return this.name;
    }

    public GatewayRouteSet withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public GatewayRouteSet withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public Map<String, List<RouteSourceDetails>> details() {
        return this.details;
    }

    public GatewayRouteSet withDetails(Map<String, List<RouteSourceDetails>> details) {
        this.details = details;
        return this;
    }

    public void validate() {
        if (this.details() != null) {
            this.details().values().forEach(e -> {
                if (e != null) {
                    e.forEach(e1 -> e1.validate());
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("details", this.details, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeJson((JsonSerializable)element1)));
        return jsonWriter.writeEndObject();
    }

    public static GatewayRouteSet fromJson(JsonReader jsonReader) throws IOException {
        return (GatewayRouteSet)jsonReader.readObject(reader -> {
            GatewayRouteSet deserializedGatewayRouteSet = new GatewayRouteSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedGatewayRouteSet.name = reader.getString();
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedGatewayRouteSet.locations = locations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("details".equals(fieldName)) {
                    Map details;
                    deserializedGatewayRouteSet.details = details = reader.readMap(reader1 -> reader1.readArray(reader2 -> RouteSourceDetails.fromJson(reader2)));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGatewayRouteSet;
        });
    }
}

