/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.RecordSet;
import java.io.IOException;
import java.util.List;

public final class PrivateDnsZonePropertiesFormat
implements JsonSerializable<PrivateDnsZonePropertiesFormat> {
    private String privateDnsZoneId;
    private List<RecordSet> recordSets;

    public String privateDnsZoneId() {
        return this.privateDnsZoneId;
    }

    public PrivateDnsZonePropertiesFormat withPrivateDnsZoneId(String privateDnsZoneId) {
        this.privateDnsZoneId = privateDnsZoneId;
        return this;
    }

    public List<RecordSet> recordSets() {
        return this.recordSets;
    }

    public void validate() {
        if (this.recordSets() != null) {
            this.recordSets().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateDnsZoneId", this.privateDnsZoneId);
        return jsonWriter.writeEndObject();
    }

    public static PrivateDnsZonePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateDnsZonePropertiesFormat)jsonReader.readObject(reader -> {
            PrivateDnsZonePropertiesFormat deserializedPrivateDnsZonePropertiesFormat = new PrivateDnsZonePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateDnsZoneId".equals(fieldName)) {
                    deserializedPrivateDnsZonePropertiesFormat.privateDnsZoneId = reader.getString();
                    continue;
                }
                if ("recordSets".equals(fieldName)) {
                    List recordSets;
                    deserializedPrivateDnsZonePropertiesFormat.recordSets = recordSets = reader.readArray(reader1 -> RecordSet.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateDnsZonePropertiesFormat;
        });
    }
}

