/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityPartnerProviderConnectionStatus;
import com.azure.resourcemanager.network.models.SecurityProviderName;
import java.io.IOException;

public final class SecurityPartnerProviderPropertiesFormat
implements JsonSerializable<SecurityPartnerProviderPropertiesFormat> {
    private ProvisioningState provisioningState;
    private SecurityProviderName securityProviderName;
    private SecurityPartnerProviderConnectionStatus connectionStatus;
    private SubResource virtualHub;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public SecurityProviderName securityProviderName() {
        return this.securityProviderName;
    }

    public SecurityPartnerProviderPropertiesFormat withSecurityProviderName(SecurityProviderName securityProviderName) {
        this.securityProviderName = securityProviderName;
        return this;
    }

    public SecurityPartnerProviderConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    public SubResource virtualHub() {
        return this.virtualHub;
    }

    public SecurityPartnerProviderPropertiesFormat withVirtualHub(SubResource virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("securityProviderName", this.securityProviderName == null ? null : this.securityProviderName.toString());
        jsonWriter.writeJsonField("virtualHub", (JsonSerializable)this.virtualHub);
        return jsonWriter.writeEndObject();
    }

    public static SecurityPartnerProviderPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityPartnerProviderPropertiesFormat)jsonReader.readObject(reader -> {
            SecurityPartnerProviderPropertiesFormat deserializedSecurityPartnerProviderPropertiesFormat = new SecurityPartnerProviderPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedSecurityPartnerProviderPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("securityProviderName".equals(fieldName)) {
                    deserializedSecurityPartnerProviderPropertiesFormat.securityProviderName = SecurityProviderName.fromString(reader.getString());
                    continue;
                }
                if ("connectionStatus".equals(fieldName)) {
                    deserializedSecurityPartnerProviderPropertiesFormat.connectionStatus = SecurityPartnerProviderConnectionStatus.fromString(reader.getString());
                    continue;
                }
                if ("virtualHub".equals(fieldName)) {
                    deserializedSecurityPartnerProviderPropertiesFormat.virtualHub = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityPartnerProviderPropertiesFormat;
        });
    }
}

