/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkTapInner;
import java.io.IOException;
import java.util.List;

public final class VirtualNetworkTapListResult
implements JsonSerializable<VirtualNetworkTapListResult> {
    private List<VirtualNetworkTapInner> value;
    private String nextLink;

    public List<VirtualNetworkTapInner> value() {
        return this.value;
    }

    public VirtualNetworkTapListResult withValue(List<VirtualNetworkTapInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public VirtualNetworkTapListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkTapListResult fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkTapListResult)jsonReader.readObject(reader -> {
            VirtualNetworkTapListResult deserializedVirtualNetworkTapListResult = new VirtualNetworkTapListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedVirtualNetworkTapListResult.value = value = reader.readArray(reader1 -> VirtualNetworkTapInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedVirtualNetworkTapListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkTapListResult;
        });
    }
}

