// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.EffectiveRouteMapRoute;
import java.io.IOException;
import java.util.List;

/**
 * EffectiveRouteMapRoute List.
 */
@Fluent
public final class EffectiveRouteMapRouteListInner implements JsonSerializable<EffectiveRouteMapRouteListInner> {
    /*
     * The list of Effective RouteMap Routes configured on the connection resource.
     */
    private List<EffectiveRouteMapRoute> value;

    /**
     * Creates an instance of EffectiveRouteMapRouteListInner class.
     */
    public EffectiveRouteMapRouteListInner() {
    }

    /**
     * Get the value property: The list of Effective RouteMap Routes configured on the connection resource.
     * 
     * @return the value value.
     */
    public List<EffectiveRouteMapRoute> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of Effective RouteMap Routes configured on the connection resource.
     * 
     * @param value the value value to set.
     * @return the EffectiveRouteMapRouteListInner object itself.
     */
    public EffectiveRouteMapRouteListInner withValue(List<EffectiveRouteMapRoute> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EffectiveRouteMapRouteListInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EffectiveRouteMapRouteListInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EffectiveRouteMapRouteListInner.
     */
    public static EffectiveRouteMapRouteListInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EffectiveRouteMapRouteListInner deserializedEffectiveRouteMapRouteListInner
                = new EffectiveRouteMapRouteListInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<EffectiveRouteMapRoute> value
                        = reader.readArray(reader1 -> EffectiveRouteMapRoute.fromJson(reader1));
                    deserializedEffectiveRouteMapRouteListInner.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEffectiveRouteMapRouteListInner;
        });
    }
}
