// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.CircuitMetadataMap;
import com.azure.resourcemanager.network.models.GatewayRouteSet;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

/**
 * Gateway Route Sets Information.
 */
@Fluent
public final class GatewayRouteSetsInformationInner implements JsonSerializable<GatewayRouteSetsInformationInner> {
    /*
     * Timestamp denoting the last time when the route sets were computed for the gateway
     */
    private OffsetDateTime lastComputedTime;

    /*
     * Timestamp denoting the next eligible time to re-compute the route sets for the gateway
     */
    private OffsetDateTime nextEligibleComputeTime;

    /*
     * Version for the route set
     */
    private String routeSetVersion;

    /*
     * List of Gateway Route Sets
     */
    private List<GatewayRouteSet> routeSets;

    /*
     * Dictionary containing map of the circuit id and circuit details
     */
    private Map<String, CircuitMetadataMap> circuitsMetadataMap;

    /**
     * Creates an instance of GatewayRouteSetsInformationInner class.
     */
    public GatewayRouteSetsInformationInner() {
    }

    /**
     * Get the lastComputedTime property: Timestamp denoting the last time when the route sets were computed for the
     * gateway.
     * 
     * @return the lastComputedTime value.
     */
    public OffsetDateTime lastComputedTime() {
        return this.lastComputedTime;
    }

    /**
     * Set the lastComputedTime property: Timestamp denoting the last time when the route sets were computed for the
     * gateway.
     * 
     * @param lastComputedTime the lastComputedTime value to set.
     * @return the GatewayRouteSetsInformationInner object itself.
     */
    public GatewayRouteSetsInformationInner withLastComputedTime(OffsetDateTime lastComputedTime) {
        this.lastComputedTime = lastComputedTime;
        return this;
    }

    /**
     * Get the nextEligibleComputeTime property: Timestamp denoting the next eligible time to re-compute the route sets
     * for the gateway.
     * 
     * @return the nextEligibleComputeTime value.
     */
    public OffsetDateTime nextEligibleComputeTime() {
        return this.nextEligibleComputeTime;
    }

    /**
     * Set the nextEligibleComputeTime property: Timestamp denoting the next eligible time to re-compute the route sets
     * for the gateway.
     * 
     * @param nextEligibleComputeTime the nextEligibleComputeTime value to set.
     * @return the GatewayRouteSetsInformationInner object itself.
     */
    public GatewayRouteSetsInformationInner withNextEligibleComputeTime(OffsetDateTime nextEligibleComputeTime) {
        this.nextEligibleComputeTime = nextEligibleComputeTime;
        return this;
    }

    /**
     * Get the routeSetVersion property: Version for the route set.
     * 
     * @return the routeSetVersion value.
     */
    public String routeSetVersion() {
        return this.routeSetVersion;
    }

    /**
     * Set the routeSetVersion property: Version for the route set.
     * 
     * @param routeSetVersion the routeSetVersion value to set.
     * @return the GatewayRouteSetsInformationInner object itself.
     */
    public GatewayRouteSetsInformationInner withRouteSetVersion(String routeSetVersion) {
        this.routeSetVersion = routeSetVersion;
        return this;
    }

    /**
     * Get the routeSets property: List of Gateway Route Sets.
     * 
     * @return the routeSets value.
     */
    public List<GatewayRouteSet> routeSets() {
        return this.routeSets;
    }

    /**
     * Set the routeSets property: List of Gateway Route Sets.
     * 
     * @param routeSets the routeSets value to set.
     * @return the GatewayRouteSetsInformationInner object itself.
     */
    public GatewayRouteSetsInformationInner withRouteSets(List<GatewayRouteSet> routeSets) {
        this.routeSets = routeSets;
        return this;
    }

    /**
     * Get the circuitsMetadataMap property: Dictionary containing map of the circuit id and circuit details.
     * 
     * @return the circuitsMetadataMap value.
     */
    public Map<String, CircuitMetadataMap> circuitsMetadataMap() {
        return this.circuitsMetadataMap;
    }

    /**
     * Set the circuitsMetadataMap property: Dictionary containing map of the circuit id and circuit details.
     * 
     * @param circuitsMetadataMap the circuitsMetadataMap value to set.
     * @return the GatewayRouteSetsInformationInner object itself.
     */
    public GatewayRouteSetsInformationInner
        withCircuitsMetadataMap(Map<String, CircuitMetadataMap> circuitsMetadataMap) {
        this.circuitsMetadataMap = circuitsMetadataMap;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (routeSets() != null) {
            routeSets().forEach(e -> e.validate());
        }
        if (circuitsMetadataMap() != null) {
            circuitsMetadataMap().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastComputedTime",
            this.lastComputedTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastComputedTime));
        jsonWriter.writeStringField("nextEligibleComputeTime",
            this.nextEligibleComputeTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.nextEligibleComputeTime));
        jsonWriter.writeStringField("routeSetVersion", this.routeSetVersion);
        jsonWriter.writeArrayField("routeSets", this.routeSets, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeMapField("circuitsMetadataMap", this.circuitsMetadataMap,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayRouteSetsInformationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayRouteSetsInformationInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayRouteSetsInformationInner.
     */
    public static GatewayRouteSetsInformationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayRouteSetsInformationInner deserializedGatewayRouteSetsInformationInner
                = new GatewayRouteSetsInformationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("lastComputedTime".equals(fieldName)) {
                    deserializedGatewayRouteSetsInformationInner.lastComputedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("nextEligibleComputeTime".equals(fieldName)) {
                    deserializedGatewayRouteSetsInformationInner.nextEligibleComputeTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("routeSetVersion".equals(fieldName)) {
                    deserializedGatewayRouteSetsInformationInner.routeSetVersion = reader.getString();
                } else if ("routeSets".equals(fieldName)) {
                    List<GatewayRouteSet> routeSets = reader.readArray(reader1 -> GatewayRouteSet.fromJson(reader1));
                    deserializedGatewayRouteSetsInformationInner.routeSets = routeSets;
                } else if ("circuitsMetadataMap".equals(fieldName)) {
                    Map<String, CircuitMetadataMap> circuitsMetadataMap
                        = reader.readMap(reader1 -> CircuitMetadataMap.fromJson(reader1));
                    deserializedGatewayRouteSetsInformationInner.circuitsMetadataMap = circuitsMetadataMap;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayRouteSetsInformationInner;
        });
    }
}
