// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * IP configuration profile child resource.
 */
@Fluent
public final class IpConfigurationProfileInner extends SubResource {
    /*
     * Properties of the IP configuration profile.
     */
    private IpConfigurationProfilePropertiesFormatInner innerProperties;

    /*
     * The name of the resource. This name can be used to access the resource.
     */
    private String name;

    /*
     * Sub Resource type.
     */
    private String type;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /**
     * Creates an instance of IpConfigurationProfileInner class.
     */
    public IpConfigurationProfileInner() {
    }

    /**
     * Get the innerProperties property: Properties of the IP configuration profile.
     * 
     * @return the innerProperties value.
     */
    private IpConfigurationProfilePropertiesFormatInner innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: The name of the resource. This name can be used to access the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource. This name can be used to access the resource.
     * 
     * @param name the name value to set.
     * @return the IpConfigurationProfileInner object itself.
     */
    public IpConfigurationProfileInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Sub Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IpConfigurationProfileInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the subnet property: The reference to the subnet resource to create a container network interface ip
     * configuration.
     * 
     * @return the subnet value.
     */
    public SubnetInner subnet() {
        return this.innerProperties() == null ? null : this.innerProperties().subnet();
    }

    /**
     * Set the subnet property: The reference to the subnet resource to create a container network interface ip
     * configuration.
     * 
     * @param subnet the subnet value to set.
     * @return the IpConfigurationProfileInner object itself.
     */
    public IpConfigurationProfileInner withSubnet(SubnetInner subnet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IpConfigurationProfilePropertiesFormatInner();
        }
        this.innerProperties().withSubnet(subnet);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the IP configuration profile resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpConfigurationProfileInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpConfigurationProfileInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the IpConfigurationProfileInner.
     */
    public static IpConfigurationProfileInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpConfigurationProfileInner deserializedIpConfigurationProfileInner = new IpConfigurationProfileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedIpConfigurationProfileInner.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedIpConfigurationProfileInner.innerProperties
                        = IpConfigurationProfilePropertiesFormatInner.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedIpConfigurationProfileInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedIpConfigurationProfileInner.type = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedIpConfigurationProfileInner.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpConfigurationProfileInner;
        });
    }
}
