// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AccessRuleDirection;
import com.azure.resourcemanager.network.models.NspProvisioningState;
import com.azure.resourcemanager.network.models.PerimeterBasedAccessRule;
import com.azure.resourcemanager.network.models.SecurityPerimeterProxyResource;
import com.azure.resourcemanager.network.models.SecurityPerimeterSystemData;
import com.azure.resourcemanager.network.models.SubscriptionId;
import java.io.IOException;
import java.util.List;

/**
 * The NSP access rule resource.
 */
@Fluent
public final class NspAccessRuleInner extends SecurityPerimeterProxyResource {
    /*
     * Properties of the NSP access rule.
     */
    private NspAccessRuleProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SecurityPerimeterSystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of NspAccessRuleInner class.
     */
    public NspAccessRuleInner() {
    }

    /**
     * Get the innerProperties property: Properties of the NSP access rule.
     * 
     * @return the innerProperties value.
     */
    private NspAccessRuleProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    @Override
    public SecurityPerimeterSystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the provisioningState property: The provisioning state of the scope assignment resource.
     * 
     * @return the provisioningState value.
     */
    public NspProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the direction property: Direction that specifies whether the access rules is inbound/outbound.
     * 
     * @return the direction value.
     */
    public AccessRuleDirection direction() {
        return this.innerProperties() == null ? null : this.innerProperties().direction();
    }

    /**
     * Set the direction property: Direction that specifies whether the access rules is inbound/outbound.
     * 
     * @param direction the direction value to set.
     * @return the NspAccessRuleInner object itself.
     */
    public NspAccessRuleInner withDirection(AccessRuleDirection direction) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAccessRuleProperties();
        }
        this.innerProperties().withDirection(direction);
        return this;
    }

    /**
     * Get the addressPrefixes property: Inbound address prefixes (IPv4/IPv6).
     * 
     * @return the addressPrefixes value.
     */
    public List<String> addressPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().addressPrefixes();
    }

    /**
     * Set the addressPrefixes property: Inbound address prefixes (IPv4/IPv6).
     * 
     * @param addressPrefixes the addressPrefixes value to set.
     * @return the NspAccessRuleInner object itself.
     */
    public NspAccessRuleInner withAddressPrefixes(List<String> addressPrefixes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAccessRuleProperties();
        }
        this.innerProperties().withAddressPrefixes(addressPrefixes);
        return this;
    }

    /**
     * Get the fullyQualifiedDomainNames property: Outbound rules in fully qualified domain name format.
     * 
     * @return the fullyQualifiedDomainNames value.
     */
    public List<String> fullyQualifiedDomainNames() {
        return this.innerProperties() == null ? null : this.innerProperties().fullyQualifiedDomainNames();
    }

    /**
     * Set the fullyQualifiedDomainNames property: Outbound rules in fully qualified domain name format.
     * 
     * @param fullyQualifiedDomainNames the fullyQualifiedDomainNames value to set.
     * @return the NspAccessRuleInner object itself.
     */
    public NspAccessRuleInner withFullyQualifiedDomainNames(List<String> fullyQualifiedDomainNames) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAccessRuleProperties();
        }
        this.innerProperties().withFullyQualifiedDomainNames(fullyQualifiedDomainNames);
        return this;
    }

    /**
     * Get the subscriptions property: List of subscription ids.
     * 
     * @return the subscriptions value.
     */
    public List<SubscriptionId> subscriptions() {
        return this.innerProperties() == null ? null : this.innerProperties().subscriptions();
    }

    /**
     * Set the subscriptions property: List of subscription ids.
     * 
     * @param subscriptions the subscriptions value to set.
     * @return the NspAccessRuleInner object itself.
     */
    public NspAccessRuleInner withSubscriptions(List<SubscriptionId> subscriptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAccessRuleProperties();
        }
        this.innerProperties().withSubscriptions(subscriptions);
        return this;
    }

    /**
     * Get the networkSecurityPerimeters property: Rule specified by the perimeter id.
     * 
     * @return the networkSecurityPerimeters value.
     */
    public List<PerimeterBasedAccessRule> networkSecurityPerimeters() {
        return this.innerProperties() == null ? null : this.innerProperties().networkSecurityPerimeters();
    }

    /**
     * Get the emailAddresses property: Outbound rules in email address format. This access rule type is currently
     * unavailable for use.
     * 
     * @return the emailAddresses value.
     */
    public List<String> emailAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().emailAddresses();
    }

    /**
     * Set the emailAddresses property: Outbound rules in email address format. This access rule type is currently
     * unavailable for use.
     * 
     * @param emailAddresses the emailAddresses value to set.
     * @return the NspAccessRuleInner object itself.
     */
    public NspAccessRuleInner withEmailAddresses(List<String> emailAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAccessRuleProperties();
        }
        this.innerProperties().withEmailAddresses(emailAddresses);
        return this;
    }

    /**
     * Get the phoneNumbers property: Outbound rules in phone number format. This access rule type is currently
     * unavailable for use.
     * 
     * @return the phoneNumbers value.
     */
    public List<String> phoneNumbers() {
        return this.innerProperties() == null ? null : this.innerProperties().phoneNumbers();
    }

    /**
     * Set the phoneNumbers property: Outbound rules in phone number format. This access rule type is currently
     * unavailable for use.
     * 
     * @param phoneNumbers the phoneNumbers value to set.
     * @return the NspAccessRuleInner object itself.
     */
    public NspAccessRuleInner withPhoneNumbers(List<String> phoneNumbers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAccessRuleProperties();
        }
        this.innerProperties().withPhoneNumbers(phoneNumbers);
        return this;
    }

    /**
     * Get the serviceTags property: Inbound rules of type service tag. This access rule type is currently unavailable
     * for use.
     * 
     * @return the serviceTags value.
     */
    public List<String> serviceTags() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceTags();
    }

    /**
     * Set the serviceTags property: Inbound rules of type service tag. This access rule type is currently unavailable
     * for use.
     * 
     * @param serviceTags the serviceTags value to set.
     * @return the NspAccessRuleInner object itself.
     */
    public NspAccessRuleInner withServiceTags(List<String> serviceTags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAccessRuleProperties();
        }
        this.innerProperties().withServiceTags(serviceTags);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (systemData() != null) {
            systemData().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspAccessRuleInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspAccessRuleInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NspAccessRuleInner.
     */
    public static NspAccessRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspAccessRuleInner deserializedNspAccessRuleInner = new NspAccessRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedNspAccessRuleInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedNspAccessRuleInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNspAccessRuleInner.type = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedNspAccessRuleInner.systemData = SecurityPerimeterSystemData.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedNspAccessRuleInner.innerProperties = NspAccessRuleProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspAccessRuleInner;
        });
    }
}
