// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingConfiguration;
import java.io.IOException;
import java.util.List;

/**
 * Parameters for P2SConnectionConfiguration.
 */
@Fluent
public final class P2SConnectionConfigurationProperties
    implements JsonSerializable<P2SConnectionConfigurationProperties> {
    /*
     * The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    private AddressSpace vpnClientAddressPool;

    /*
     * The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    private RoutingConfiguration routingConfiguration;

    /*
     * Flag indicating whether the enable internet security flag is turned on for the P2S Connections or not.
     */
    private Boolean enableInternetSecurity;

    /*
     * List of Configuration Policy Groups that this P2SConnectionConfiguration is attached to.
     */
    private List<SubResource> configurationPolicyGroupAssociations;

    /*
     * List of previous Configuration Policy Groups that this P2SConnectionConfiguration was attached to.
     */
    private List<VpnServerConfigurationPolicyGroupInner> previousConfigurationPolicyGroupAssociations;

    /*
     * The provisioning state of the P2SConnectionConfiguration resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of P2SConnectionConfigurationProperties class.
     */
    public P2SConnectionConfigurationProperties() {
    }

    /**
     * Get the vpnClientAddressPool property: The reference to the address space resource which represents Address space
     * for P2S VpnClient.
     * 
     * @return the vpnClientAddressPool value.
     */
    public AddressSpace vpnClientAddressPool() {
        return this.vpnClientAddressPool;
    }

    /**
     * Set the vpnClientAddressPool property: The reference to the address space resource which represents Address space
     * for P2S VpnClient.
     * 
     * @param vpnClientAddressPool the vpnClientAddressPool value to set.
     * @return the P2SConnectionConfigurationProperties object itself.
     */
    public P2SConnectionConfigurationProperties withVpnClientAddressPool(AddressSpace vpnClientAddressPool) {
        this.vpnClientAddressPool = vpnClientAddressPool;
        return this;
    }

    /**
     * Get the routingConfiguration property: The Routing Configuration indicating the associated and propagated route
     * tables on this connection.
     * 
     * @return the routingConfiguration value.
     */
    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    /**
     * Set the routingConfiguration property: The Routing Configuration indicating the associated and propagated route
     * tables on this connection.
     * 
     * @param routingConfiguration the routingConfiguration value to set.
     * @return the P2SConnectionConfigurationProperties object itself.
     */
    public P2SConnectionConfigurationProperties withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    /**
     * Get the enableInternetSecurity property: Flag indicating whether the enable internet security flag is turned on
     * for the P2S Connections or not.
     * 
     * @return the enableInternetSecurity value.
     */
    public Boolean enableInternetSecurity() {
        return this.enableInternetSecurity;
    }

    /**
     * Set the enableInternetSecurity property: Flag indicating whether the enable internet security flag is turned on
     * for the P2S Connections or not.
     * 
     * @param enableInternetSecurity the enableInternetSecurity value to set.
     * @return the P2SConnectionConfigurationProperties object itself.
     */
    public P2SConnectionConfigurationProperties withEnableInternetSecurity(Boolean enableInternetSecurity) {
        this.enableInternetSecurity = enableInternetSecurity;
        return this;
    }

    /**
     * Get the configurationPolicyGroupAssociations property: List of Configuration Policy Groups that this
     * P2SConnectionConfiguration is attached to.
     * 
     * @return the configurationPolicyGroupAssociations value.
     */
    public List<SubResource> configurationPolicyGroupAssociations() {
        return this.configurationPolicyGroupAssociations;
    }

    /**
     * Set the configurationPolicyGroupAssociations property: List of Configuration Policy Groups that this
     * P2SConnectionConfiguration is attached to.
     * 
     * @param configurationPolicyGroupAssociations the configurationPolicyGroupAssociations value to set.
     * @return the P2SConnectionConfigurationProperties object itself.
     */
    public P2SConnectionConfigurationProperties
        withConfigurationPolicyGroupAssociations(List<SubResource> configurationPolicyGroupAssociations) {
        this.configurationPolicyGroupAssociations = configurationPolicyGroupAssociations;
        return this;
    }

    /**
     * Get the previousConfigurationPolicyGroupAssociations property: List of previous Configuration Policy Groups that
     * this P2SConnectionConfiguration was attached to.
     * 
     * @return the previousConfigurationPolicyGroupAssociations value.
     */
    public List<VpnServerConfigurationPolicyGroupInner> previousConfigurationPolicyGroupAssociations() {
        return this.previousConfigurationPolicyGroupAssociations;
    }

    /**
     * Get the provisioningState property: The provisioning state of the P2SConnectionConfiguration resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (vpnClientAddressPool() != null) {
            vpnClientAddressPool().validate();
        }
        if (routingConfiguration() != null) {
            routingConfiguration().validate();
        }
        if (previousConfigurationPolicyGroupAssociations() != null) {
            previousConfigurationPolicyGroupAssociations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("vpnClientAddressPool", this.vpnClientAddressPool);
        jsonWriter.writeJsonField("routingConfiguration", this.routingConfiguration);
        jsonWriter.writeBooleanField("enableInternetSecurity", this.enableInternetSecurity);
        jsonWriter.writeArrayField("configurationPolicyGroupAssociations", this.configurationPolicyGroupAssociations,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of P2SConnectionConfigurationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of P2SConnectionConfigurationProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the P2SConnectionConfigurationProperties.
     */
    public static P2SConnectionConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            P2SConnectionConfigurationProperties deserializedP2SConnectionConfigurationProperties
                = new P2SConnectionConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vpnClientAddressPool".equals(fieldName)) {
                    deserializedP2SConnectionConfigurationProperties.vpnClientAddressPool
                        = AddressSpace.fromJson(reader);
                } else if ("routingConfiguration".equals(fieldName)) {
                    deserializedP2SConnectionConfigurationProperties.routingConfiguration
                        = RoutingConfiguration.fromJson(reader);
                } else if ("enableInternetSecurity".equals(fieldName)) {
                    deserializedP2SConnectionConfigurationProperties.enableInternetSecurity
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("configurationPolicyGroupAssociations".equals(fieldName)) {
                    List<SubResource> configurationPolicyGroupAssociations
                        = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedP2SConnectionConfigurationProperties.configurationPolicyGroupAssociations
                        = configurationPolicyGroupAssociations;
                } else if ("previousConfigurationPolicyGroupAssociations".equals(fieldName)) {
                    List<VpnServerConfigurationPolicyGroupInner> previousConfigurationPolicyGroupAssociations
                        = reader.readArray(reader1 -> VpnServerConfigurationPolicyGroupInner.fromJson(reader1));
                    deserializedP2SConnectionConfigurationProperties.previousConfigurationPolicyGroupAssociations
                        = previousConfigurationPolicyGroupAssociations;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedP2SConnectionConfigurationProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedP2SConnectionConfigurationProperties;
        });
    }
}
